/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.uncjournals;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import jxl.Cell;
import jxl.Sheet;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.oro.text.perl.Perl5Util;

public class ExcelUtil {
    private String name;
    private String type;
    private int length;
    private String value;
    private boolean upperCase;
    private boolean removeSuffix;
    private int suffixChar;

    public ExcelUtil(String name, String type, int length, String value) {
        this.name = name;
        this.type = type;
        this.length = length;
        this.value = value;
    }

    public ExcelUtil(String name, String type, int length, String value, boolean upperCase) {
        this.name = name;
        this.type = type;
        this.length = length;
        this.value = value;
        this.upperCase = upperCase;
    }

    public ExcelUtil(String name, String type, int length, String value, boolean upperCase, boolean removeSuffix, int suffixChar) {
        this.name = name;
        this.type = type;
        this.length = length;
        this.value = value;
        this.upperCase = upperCase;
        this.removeSuffix = removeSuffix;
        this.suffixChar = suffixChar;
    }

    public static String cleanVARCHAR(Cell cell) {
        Perl5Util util = new Perl5Util();
        String str = cell.getContents();
        str = util.substitute("s/[']/\\\\'/g", str);
        return str;
    }

    public static String cleanINT(Cell cell) {
        Perl5Util util = new Perl5Util();
        String str = cell.getContents();
        return (str = util.substitute("s/[,]//g", str)).length() == 0 ? "-1" : str;
    }

    public static String cleanFLOAT(Cell cell) {
        Perl5Util util = new Perl5Util();
        String str = cell.getContents();
        return (str = util.substitute("s/[,]//g", str)).length() == 0 ? "-1" : str;
    }

    public static void createTable(Vector columns, boolean usePKey, Connection dbConn, String table) throws Exception {
        ExcelUtil eutil;
        int i;
        System.out.println("Creating table " + table);
        String sql = "create table " + table + "(";
        if (usePKey) {
            sql = sql + "id int auto_increment,";
        }
        int size = columns.size();
        for (i = 0; i < size - 1; ++i) {
            eutil = (ExcelUtil)columns.elementAt(i);
            sql = eutil.type.equals("TEXT") ? sql + eutil.name + " " + eutil.type + "," : sql + eutil.name + " " + eutil.type + "(" + eutil.length + "),";
        }
        eutil = (ExcelUtil)columns.elementAt(i);
        sql = eutil.type.equals("TEXT") ? sql + eutil.name + " " + eutil.type : sql + eutil.name + " " + eutil.type + "(" + eutil.length + ")";
        if (usePKey) {
            sql = sql + ", primary key(id)";
        }
        sql = sql + ")";
        System.out.println("sql is " + sql);
        Statement stmt = dbConn.createStatement();
        stmt.execute(sql);
    }

    public static void addRow(Vector columns, Sheet sheet, int rowIdx, Connection dbConn, String table) throws Exception {
        ExcelUtil eutil;
        int i;
        System.out.println("Adding row " + rowIdx + " of " + table);
        int size = columns.size();
        for (i = 0; i < size; ++i) {
            int idx;
            Cell cell = sheet.getCell(i, rowIdx);
            eutil = (ExcelUtil)columns.elementAt(i);
            eutil.value = eutil.type.endsWith("CHAR") || eutil.type.startsWith("TEXT") ? ExcelUtil.cleanVARCHAR(cell) : (eutil.type.startsWith("INT") ? ExcelUtil.cleanINT(cell) : ExcelUtil.cleanFLOAT(cell));
            if (eutil.upperCase) {
                eutil.value = eutil.value.toUpperCase();
            }
            if (eutil.removeSuffix && (idx = eutil.value.indexOf(eutil.suffixChar)) != -1) {
                eutil.value = eutil.value.substring(0, idx).trim();
            }
            columns.setElementAt(eutil, i);
        }
        String sql = "insert into " + table + "(";
        size = columns.size();
        for (i = 0; i < size - 1; ++i) {
            eutil = (ExcelUtil)columns.elementAt(i);
            sql = sql + eutil.name + ",";
        }
        eutil = (ExcelUtil)columns.elementAt(i);
        sql = sql + eutil.name;
        sql = sql + ") values (";
        size = columns.size();
        for (i = 0; i < size - 1; ++i) {
            eutil = (ExcelUtil)columns.elementAt(i);
            sql = sql + "'" + eutil.value + "',";
        }
        eutil = (ExcelUtil)columns.elementAt(i);
        sql = sql + "'" + eutil.value + "'";
        sql = sql + ")";
        System.out.println(sql);
        Statement stmt = dbConn.createStatement();
        stmt.executeUpdate(sql);
    }

    void createWorkSheet(WritableWorkbook wbk, String name, ResultSet schema, ResultSet rs) throws Exception {
        WritableSheet sheet = wbk.createSheet(name, 0);
        int i = 0;
        int numCol = 0;
        schema.beforeFirst();
        Vector<String> colType = new Vector<String>();
        while (schema.next()) {
            sheet.addCell((WritableCell)new Label(i, 0, schema.getString("Field")));
            colType.add(schema.getString("Type"));
            ++i;
            ++numCol;
        }
        numCol = i;
        int j = 1;
        rs.beforeFirst();
        while (rs.next()) {
            for (i = 0; i < numCol; ++i) {
                if (((String)colType.elementAt(i)).startsWith("int")) {
                    sheet.addCell((WritableCell)new Number(i, j, (double)Integer.parseInt(rs.getString(i + 1))));
                    continue;
                }
                if (((String)colType.elementAt(i)).startsWith("float")) {
                    sheet.addCell((WritableCell)new Number(i, j, (double)Float.parseFloat(rs.getString(i + 1))));
                    continue;
                }
                if (((String)colType.elementAt(i)).startsWith("double")) {
                    sheet.addCell((WritableCell)new Number(i, j, Double.parseDouble(rs.getString(i + 1))));
                    continue;
                }
                sheet.addCell((WritableCell)new Label(i, j, rs.getString(i + 1)));
            }
            ++j;
        }
    }
}

