/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.spider;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.oro.text.perl.Perl5Util;
import org.neoref.config.Config;
import org.neoref.spider.MeshAdder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class MeshAddHandler
extends DefaultHandler {
    private boolean inPubmedArticleSet = false;
    private boolean inPubmedArticle = false;
    private boolean inPMID = false;
    private boolean inArticleTitle = false;
    private boolean inAbstractText = false;
    private boolean inMeshHeadingList = false;
    private boolean inMeshHeading = false;
    private boolean inDescriptorName = false;
    private boolean inDescriptorMajorTopic = false;
    private boolean inQualifierName = false;
    private boolean inQualifierMajorTopic = false;
    private boolean inComment = false;
    private boolean inArticleDate = false;
    private boolean inYear = false;
    private boolean inMonth = false;
    private boolean inDay = false;
    private String pmid;
    private String articleTitle;
    private String abstractText;
    private String meshHeadingList;
    private String year;
    private String month;
    private String day;
    private String date;
    private Connection dbConn;
    private Perl5Util util = new Perl5Util();

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes atts) throws SAXException {
        if (localName.equals("PubmedArticleSet")) {
            MeshAdder.count = 0;
            this.inPubmedArticleSet = true;
        } else if (localName.equals("PubmedArticle")) {
            this.inPubmedArticle = true;
        } else if (localName.equals("PMID") && !this.inComment) {
            this.pmid = new String();
            this.inPMID = true;
        } else if (localName.equals("ArticleTitle")) {
            this.articleTitle = new String();
            this.inArticleTitle = true;
        } else if (localName.equals("AbstractText")) {
            this.abstractText = new String();
            this.inAbstractText = true;
        } else if (localName.equals("MeshHeadingList")) {
            this.meshHeadingList = new String();
            this.inMeshHeadingList = true;
        } else if (localName.equals("MeshHeading")) {
            this.inMeshHeading = true;
        } else if (localName.equals("DescriptorName")) {
            this.inDescriptorName = true;
            this.inDescriptorMajorTopic = atts.getValue(atts.getIndex("MajorTopicYN")).equals("Y");
        } else if (localName.equals("QualifierName")) {
            this.inQualifierName = true;
            this.inQualifierMajorTopic = atts.getValue(atts.getIndex("MajorTopicYN")).equals("Y");
        } else if (localName.equals("CommentIn") || localName.equals("CommentOn")) {
            this.inComment = true;
        } else if (localName.equals("ArticleDate")) {
            this.inArticleDate = true;
        } else if (localName.equals("Year") && this.inArticleDate) {
            this.year = new String();
            this.inYear = true;
        } else if (localName.equals("Month") && this.inArticleDate) {
            this.month = new String();
            this.inMonth = true;
        } else if (localName.equals("Day") && this.inArticleDate) {
            this.day = new String();
            this.inDay = true;
        }
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        if (localName.equals("PubmedArticleSet")) {
            this.inPubmedArticleSet = false;
        } else if (localName.equals("PubmedArticle")) {
            try {
                Statement st;
                ResultSet rs;
                if (this.dbConn == null) {
                    Class.forName("com.mysql.jdbc.Driver").newInstance();
                    this.dbConn = DriverManager.getConnection(Config.SEARCHDB_STR);
                }
                if ((rs = (st = this.dbConn.createStatement()).executeQuery("select * from metadata where pmid='" + this.pmid + "'")).next()) {
                    if (MeshAdder.checkdup == 0 || rs.getString("title").length() == 0) {
                        this.date = this.year + "-" + this.month + "-" + this.day;
                        this.articleTitle = this.util.substitute("s/[']/ /g", this.articleTitle);
                        this.abstractText = this.util.substitute("s/[']/ /g", this.abstractText);
                        st.executeUpdate("update metadata set description='" + this.abstractText + "', mesh='" + this.meshHeadingList + "', title='" + this.articleTitle + "', date='" + this.date + "' where pmid='" + this.pmid + "';");
                        System.out.println("record id: " + rs.getInt("id") + " updated (pmid: " + this.pmid + ")");
                    } else {
                        System.out.println("duplicate found (pmid: " + this.pmid + ")");
                    }
                } else {
                    System.out.println("no update for pmid: " + this.pmid);
                }
            }
            catch (Exception e) {
                System.out.println("Cannot add mesh heading");
            }
            this.inPubmedArticle = false;
            this.abstractText = null;
            this.meshHeadingList = null;
            this.articleTitle = null;
            this.pmid = null;
            this.year = null;
            this.month = null;
            this.day = null;
            this.date = null;
        } else if (localName.equals("PMID") && this.inPMID) {
            System.out.println("handling item " + ++MeshAdder.count + " (pmid: " + this.pmid + ")");
            this.inPMID = false;
        } else if (localName.equals("ArticleTitle") && this.inArticleTitle) {
            this.inArticleTitle = false;
        } else if (localName.equals("AbstractText")) {
            this.inAbstractText = false;
        } else if (localName.equals("MeshHeadingList") && this.inMeshHeadingList) {
            this.meshHeadingList = this.meshHeadingList.replace('\'', ' ');
            this.inMeshHeadingList = false;
        } else if (localName.equals("MeshHeading") && this.inMeshHeading) {
            this.meshHeadingList = this.meshHeadingList + "|";
            this.inMeshHeading = false;
        } else if (localName.equals("DescriptorName") && this.inDescriptorName) {
            this.meshHeadingList = this.inDescriptorMajorTopic ? this.meshHeadingList + "(Y)" + "!" : this.meshHeadingList + "(N)" + "!";
            this.inDescriptorName = false;
        } else if (localName.equals("QualifierName") && this.inQualifierName) {
            this.meshHeadingList = this.inQualifierMajorTopic ? this.meshHeadingList + "(Y)" + ":" : this.meshHeadingList + "(N)" + ":";
            this.inQualifierName = false;
        } else if ((localName.equals("CommentIn") || localName.equals("CommentOn")) && this.inComment) {
            this.inComment = false;
        } else if (localName.equals("ArticleDate") && this.inArticleDate) {
            this.inArticleDate = false;
        } else if (localName.equals("Year") && this.inYear) {
            this.inYear = false;
        } else if (localName.equals("Month") && this.inMonth) {
            this.inMonth = false;
        } else if (localName.equals("Day") && this.inDay) {
            this.inDay = false;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inPMID && !this.inComment) {
            this.pmid = this.pmid + new String(ch, start, length);
        }
        if (this.inArticleTitle) {
            this.articleTitle = this.articleTitle + new String(ch, start, length);
        }
        if (this.inAbstractText) {
            this.abstractText = this.abstractText + new String(ch, start, length);
        }
        if (this.inDescriptorName) {
            this.meshHeadingList = this.meshHeadingList + new String(ch, start, length);
        }
        if (this.inQualifierName) {
            this.meshHeadingList = this.meshHeadingList + new String(ch, start, length);
        }
        if (this.inYear) {
            this.year = this.year + new String(ch, start, length);
        }
        if (this.inMonth) {
            this.month = this.month + new String(ch, start, length);
        }
        if (this.inDay) {
            this.day = this.day + new String(ch, start, length);
        }
    }

    public void warning(SAXParseException exception) throws SAXException {
        this.inPubmedArticleSet = false;
        this.inPubmedArticle = false;
        this.inPMID = false;
        this.inArticleTitle = false;
        this.inAbstractText = false;
        this.inMeshHeadingList = false;
        this.inMeshHeading = false;
        this.inDescriptorName = false;
        this.inDescriptorMajorTopic = false;
        this.inQualifierName = false;
        this.inQualifierMajorTopic = false;
        this.inComment = false;
        this.inArticleDate = false;
        this.inYear = false;
        this.inMonth = false;
        this.inDay = false;
        System.out.println("**Warning**  Line: " + exception.getLineNumber() + " URI: " + exception.getSystemId() + " Message: " + exception.getMessage());
        throw new SAXException("Warning encountered");
    }

    public void error(SAXParseException exception) throws SAXException {
        this.inPubmedArticleSet = false;
        this.inPubmedArticle = false;
        this.inPMID = false;
        this.inArticleTitle = false;
        this.inAbstractText = false;
        this.inMeshHeadingList = false;
        this.inMeshHeading = false;
        this.inDescriptorName = false;
        this.inDescriptorMajorTopic = false;
        this.inQualifierName = false;
        this.inQualifierMajorTopic = false;
        this.inComment = false;
        this.inArticleDate = false;
        this.inYear = false;
        this.inMonth = false;
        this.inDay = false;
        System.out.println("**Error**  Line: " + exception.getLineNumber() + " URI: " + exception.getSystemId() + " Message: " + exception.getMessage());
        throw new SAXException("Error encountered");
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        this.inPubmedArticleSet = false;
        this.inPubmedArticle = false;
        this.inPMID = false;
        this.inArticleTitle = false;
        this.inAbstractText = false;
        this.inMeshHeadingList = false;
        this.inMeshHeading = false;
        this.inDescriptorName = false;
        this.inDescriptorMajorTopic = false;
        this.inQualifierName = false;
        this.inQualifierMajorTopic = false;
        this.inComment = false;
        this.inArticleDate = false;
        this.inYear = false;
        this.inMonth = false;
        this.inDay = false;
        System.out.println("**Fatal Error**  Line: " + exception.getLineNumber() + " URI: " + exception.getSystemId() + " Message: " + exception.getMessage());
        throw new SAXException("Fatal Error encountered");
    }
}

