/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.oro.text.perl.Perl5Util;
import org.neoref.config.Config;
import org.neoref.index.NRAnalyzer;
import org.neoref.query.QueryArgs;
import org.neoref.query.QueryResults;

public class NRQuery {
    private static Searcher searcher;
    private static long lastModified;
    private static Logger log;
    static /* synthetic */ Class class$org$neoref$query$NRQuery;

    public static QueryResults doQuery(QueryArgs args, boolean useCluster) throws IOException {
        String querystring = args.getQuery();
        QueryResults qr = new QueryResults();
        ArrayList<String> hitIDs = new ArrayList<String>();
        ArrayList<String> allHitIDs = new ArrayList<String>();
        int start = args.getStart();
        int pageSize = args.getPageSize();
        qr.setHitIDs(hitIDs);
        qr.setAllHitIDs(allHitIDs);
        qr.setStart(start);
        qr.setPageSize(pageSize);
        querystring = NRQuery.checkEmptyQuery(querystring);
        querystring = NRQuery.workAroundLuceneBug(querystring);
        querystring = NRQuery.stripAsterisk(querystring);
        try {
            String idStr;
            Document doc;
            int i;
            Searcher searcher = NRQuery.getSearcher(Config.INDEX_DIRECTORY);
            log.debug((Object)("billy: querystring is " + querystring));
            MultiFieldQueryParser qp = new MultiFieldQueryParser("default", (Analyzer)new NRAnalyzer());
            Query myquery = qp.parse(querystring);
            Hits hits = searcher.search(myquery);
            int hitCount = hits.length();
            qr.setHitCount(hitCount);
            if (start < hitCount) {
                int hitsRemaining = hitCount - start;
                int hitsToProcess = hitsRemaining < pageSize ? hitsRemaining : pageSize;
                int end = start + hitsToProcess;
                for (i = start; i < end; ++i) {
                    doc = hits.doc(i);
                    idStr = doc.get("Id");
                    hitIDs.add(idStr);
                }
            }
            qr.setHitCount(hitIDs.size());
            if (useCluster) {
                for (i = 0; i < hitCount; ++i) {
                    doc = hits.doc(i);
                    idStr = doc.get("Id");
                    allHitIDs.add(idStr);
                }
            }
            qr.setAllHitCount(hitCount);
        }
        catch (NumberFormatException e) {
        }
        catch (ParseException e) {
            log.warn((Object)("Lucene Parse Exception " + e.getMessage()));
        }
        return qr;
    }

    static String checkEmptyQuery(String myquery) {
        if (myquery.equals("")) {
            myquery = "empty_query_string";
        }
        return myquery;
    }

    static String workAroundLuceneBug(String myquery) {
        Perl5Util util = new Perl5Util();
        myquery = util.substitute("s/ AND / && /g", myquery);
        myquery = util.substitute("s/ OR / || /g", myquery);
        myquery = util.substitute("s/ NOT / ! /g", myquery);
        myquery = myquery.toLowerCase();
        myquery = util.substitute("s/ to / TO /g", myquery);
        return myquery;
    }

    static String stripHandles(String myquery) {
        Perl5Util util = new Perl5Util();
        myquery = util.substitute("s|^(\\s+)?http://hdl\\.handle\\.net/||", myquery);
        myquery = util.substitute("s|^(\\s+)?hdl:||", myquery);
        return myquery;
    }

    static String stripAsterisk(String myquery) {
        Perl5Util util = new Perl5Util();
        myquery = util.substitute("s/^\\*//", myquery);
        myquery = util.substitute("s| \\*| |", myquery);
        myquery = util.substitute("s|\\(\\*|\\(|", myquery);
        myquery = util.substitute("s|:\\*|:|", myquery);
        return myquery;
    }

    public static void doCMDLineQuery(String query) {
        System.out.println("Command line query: " + query);
        System.out.println("Only reporting default-sized results list");
        try {
            QueryArgs args = new QueryArgs();
            args.setQuery(query);
            QueryResults results = NRQuery.doQuery(args, false);
            Iterator i = results.getHitIDs().iterator();
            while (i.hasNext()) {
                String thisID = (String)i.next();
                System.out.println("Records:\t" + thisID);
            }
        }
        catch (Exception e) {
            System.out.println("Exception caught: " + e);
        }
    }

    public static void main(String[] args) {
        NRQuery q = new NRQuery();
        if (args.length > 0) {
            NRQuery.doCMDLineQuery(args[0]);
        }
    }

    private static synchronized Searcher getSearcher(String indexDir) throws IOException {
        if (lastModified != IndexReader.lastModified((String)indexDir)) {
            lastModified = IndexReader.lastModified((String)indexDir);
            searcher = new IndexSearcher(indexDir);
        }
        return searcher;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        log = Logger.getLogger((Class)(class$org$neoref$query$NRQuery == null ? (class$org$neoref$query$NRQuery = NRQuery.class$("org.neoref.query.NRQuery")) : class$org$neoref$query$NRQuery));
    }
}

