/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.profile;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.apache.oro.text.perl.Perl5Util;
import org.neoref.config.Config;
import org.neoref.core.DC;
import org.neoref.core.Meta;
import org.neoref.query.NRQuery;
import org.neoref.query.QueryArgs;
import org.neoref.query.QueryResults;

public class DBProfilerHgAll
extends Thread {
    String atStr;
    Vector atVec;
    int graph;

    DBProfilerHgAll(String atStr, Vector atVec, int graph) {
        this.atStr = atStr;
        this.atVec = atVec;
        this.graph = graph;
    }

    public void run() {
        try {
            String at;
            int m;
            int k;
            String field;
            int j;
            DC dc;
            int size;
            int i;
            int metaCount = 0;
            int ftCount = 0;
            int allCount = 0;
            QueryResults qResults = null;
            QueryArgs qArgs = new QueryArgs();
            String[] qArray = new String[DC.DCN_FT];
            Perl5Util util = new Perl5Util();
            DC.init();
            qArray[0] = "((" + DC.dcName[0].toLowerCase() + ":" + this.atStr + ")";
            for (i = 1; i < DC.DCN_FT; ++i) {
                if (i == DC.DC_FULLTXT || i == DC.DC_IDENTIFIER) continue;
                qArray[0] = qArray[0] + " OR (" + DC.dcName[i].toLowerCase() + ":" + this.atStr + ")";
            }
            qArray[0] = qArray[0] + ")";
            qArgs.setQuery(qArray[0]);
            qArgs.setStart(0);
            qResults = NRQuery.doQuery(qArgs, false);
            List res = qResults.getAllHitIDs();
            metaCount = res.size();
            int metaInstCount = 0;
            for (i = 0; i < metaCount; ++i) {
                size = this.atVec.size();
                dc = Meta.getRecordFT((int)new Integer((String)res.get(i)));
                for (j = 1; j < DC.DCN_FT; ++j) {
                    if (j == DC.DC_FULLTXT || j == DC.DC_MESH || (field = ((String)dc.value.get(j)).toLowerCase()) == null || field.length() == 0) continue;
                    for (k = 0; k < size; ++k) {
                        m = 0;
                        at = ((String)this.atVec.elementAt(k)).toLowerCase();
                        while (m != -1) {
                            if ((m = field.indexOf(at, m + 1)) == -1) continue;
                            ++metaInstCount;
                        }
                    }
                }
            }
            qArray[0] = "(" + DC.dcName[DC.DC_FULLTXT].toLowerCase() + ":" + this.atStr + ")";
            qArgs.setQuery(qArray[0]);
            qArgs.setStart(0);
            qResults = NRQuery.doQuery(qArgs, false);
            res = qResults.getAllHitIDs();
            ftCount = res.size();
            int ftInstCount = 0;
            for (i = 0; i < ftCount; ++i) {
                size = this.atVec.size();
                dc = Meta.getRecordFT((int)new Integer((String)res.get(i)));
                for (j = 1; j < DC.DCN_FT; ++j) {
                    if (j != DC.DC_FULLTXT || (field = ((String)dc.value.get(j)).toLowerCase()) == null || field.length() == 0) continue;
                    for (k = 0; k < size; ++k) {
                        m = 0;
                        at = ((String)this.atVec.elementAt(k)).toLowerCase();
                        while (m != -1) {
                            if ((m = field.indexOf(at, m + 1)) == -1) continue;
                            ++ftInstCount;
                        }
                    }
                }
            }
            qArray[0] = "((" + DC.dcName[0].toLowerCase() + ":" + this.atStr + ")";
            for (i = 1; i < DC.DCN_FT; ++i) {
                qArray[0] = qArray[0] + " OR (" + DC.dcName[i].toLowerCase() + ":" + this.atStr + ")";
            }
            qArray[0] = qArray[0] + ")";
            qArgs.setQuery(qArray[0]);
            qArgs.setStart(0);
            qResults = NRQuery.doQuery(qArgs, false);
            allCount = qResults.getHitCount();
            if (this.graph == 0) {
                System.out.println(this.atStr + "," + metaCount + "," + ftCount + "," + metaInstCount + "," + ftInstCount);
            } else {
                System.out.println(metaCount + "," + ftCount + "," + metaInstCount + "," + ftInstCount);
            }
        }
        catch (Exception e) {
            DBProfilerHgAll.log("Error message: " + e.getMessage());
        }
    }

    public static void log(String entry) {
        System.out.println(new Date() + ":" + entry);
    }

    public static void main(String[] args) throws Exception {
        String temp;
        int graph = 0;
        Connection dbConn = null;
        if (args.length < 1) {
            System.out.println("Usage: dbprofilehg graph");
            System.out.println("graph: 1 for output formatted for octave plotting; 0 for text file output");
            System.exit(-1);
        }
        graph = Integer.parseInt(args[0]);
        Class.forName("com.mysql.jdbc.Driver").newInstance();
        dbConn = DriverManager.getConnection(Config.SEARCHDB_STR);
        Statement stmt = dbConn.createStatement();
        Vector<String> geneVec = new Vector<String>();
        ResultSet rs = stmt.executeQuery("select geneSymbol from kgXref;");
        if (!rs.next()) {
            DBProfilerHgAll.log("No gene in database");
            System.exit(-1);
        }
        while (rs.next()) {
            temp = rs.getString("geneSymbol");
            if (geneVec.contains(temp)) continue;
            geneVec.add(temp);
        }
        Vector<String> atVec = new Vector<String>();
        int size = geneVec.size();
        for (int i = 0; i < size; ++i) {
            temp = (String)geneVec.elementAt(i);
            temp = temp.replace('\'', ' ');
            rs = stmt.executeQuery("select * from kgXref where geneSymbol='" + temp + "';");
            if (!rs.next()) continue;
            rs.beforeFirst();
            atVec.clear();
            String atStr = "\"" + temp + "\"";
            atVec.add(temp);
            while (rs.next()) {
                temp = rs.getString("kgID");
                if (!atVec.contains(temp)) {
                    atStr = atStr + " OR ";
                    atStr = atStr + "\"" + temp + "\"";
                    atVec.add(temp);
                }
                if (!atVec.contains(temp = rs.getString("mRNA"))) {
                    atStr = atStr + " OR ";
                    atStr = atStr + "\"" + temp + "\"";
                    atVec.add(temp);
                }
                if (!atVec.contains(temp = rs.getString("spID"))) {
                    atStr = atStr + " OR ";
                    atStr = atStr + "\"" + temp + "\"";
                    atVec.add(temp);
                }
                if (!atVec.contains(temp = rs.getString("spDisplayID"))) {
                    atStr = atStr + " OR ";
                    atStr = atStr + "\"" + temp + "\"";
                    atVec.add(temp);
                }
                if (!atVec.contains(temp = rs.getString("refseq"))) {
                    atStr = atStr + " OR ";
                    atStr = atStr + "\"" + temp + "\"";
                    atVec.add(temp);
                }
                if (atVec.contains(temp = rs.getString("protAcc"))) continue;
                atStr = atStr + " OR ";
                atStr = atStr + "\"" + temp + "\"";
                atVec.add(temp);
            }
            atStr = "(" + atStr + ")";
            DBProfilerHgAll pf = new DBProfilerHgAll(atStr, atVec, graph);
            pf.start();
            pf.join();
        }
        DBProfilerHgAll.log("Done with profiling!");
    }
}

