/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.profile;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.oro.text.perl.Perl5Util;
import org.neoref.core.DC;
import org.neoref.core.Meta;
import org.neoref.query.NRQuery;
import org.neoref.query.QueryArgs;
import org.neoref.query.QueryResults;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AllProfiler
extends Thread {
    String atStr;
    String esearchStr;
    int graph;
    static Vector titles;

    AllProfiler(String atStr, String esearchStr, int graph) {
        this.atStr = atStr;
        this.esearchStr = esearchStr;
        this.graph = graph;
    }

    public static void setTitles(Vector t) {
        titles = t;
    }

    public void run() {
        try {
            int i;
            int metaCount = 0;
            int ftCount = 0;
            int allCount = 0;
            int pmCount = 0;
            int pmcCount = 0;
            QueryResults qResults = null;
            QueryArgs qArgs = new QueryArgs();
            String[] qArray = new String[DC.DCN_FT];
            Perl5Util util = new Perl5Util();
            DC.init();
            qArray[0] = "(((" + DC.dcName[0].toLowerCase() + ":" + this.atStr + ")";
            for (i = 1; i < DC.DCN_FT; ++i) {
                if (i == DC.DC_FULLTXT || i == DC.DC_IDENTIFIER) continue;
                qArray[0] = qArray[0] + " OR (" + DC.dcName[i].toLowerCase() + ":" + this.atStr + ")";
            }
            qArray[0] = qArray[0] + ") AND (identifier:(\"pubmedcentral\")))";
            qArgs.setQuery(qArray[0]);
            qArgs.setStart(0);
            qResults = NRQuery.doQuery(qArgs, false);
            List res = qResults.getHitIDs();
            int size = res.size();
            for (i = 0; i < size; ++i) {
                DC dc = Meta.getRecordFT((int)new Integer((String)res.get(i)));
                String titleStr = (String)dc.value.get(DC.DC_TITLE);
                if (!(titleStr = util.substitute("s/\\n//g", titleStr)).endsWith(".")) {
                    titleStr = titleStr + ".";
                }
                if (!titles.contains(titleStr.toLowerCase())) continue;
                ++metaCount;
            }
            qArray[0] = "((" + DC.dcName[DC.DC_FULLTXT].toLowerCase() + ":" + this.atStr + ") AND (identifier:(\"plantcell\" OR \"plantphysiol\" OR \"genesdev\" OR \"oupjournals\")))";
            qArgs.setQuery(qArray[0]);
            qArgs.setStart(0);
            qResults = NRQuery.doQuery(qArgs, false);
            ftCount = qResults.getHitCount();
            qArray[0] = "((" + DC.dcName[0].toLowerCase() + ":" + this.atStr + ")";
            for (i = 1; i < DC.DCN_FT; ++i) {
                qArray[0] = qArray[0] + " OR (" + DC.dcName[i].toLowerCase() + ":" + this.atStr + ")";
            }
            qArray[0] = qArray[0] + ")";
            qArgs.setQuery(qArray[0]);
            qArgs.setStart(0);
            qResults = NRQuery.doQuery(qArgs, false);
            allCount = qResults.getHitCount();
            URL esearchURL = new URL("http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi?db=pubmed&term=" + this.esearchStr);
            URLConnection conn = esearchURL.openConnection();
            InputStream is = conn.getInputStream();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document xmlDoc = db.parse(is);
            pmCount = Integer.parseInt(xmlDoc.getElementsByTagName("Count").item(0).getFirstChild().getNodeValue());
            esearchURL = new URL("http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi?db=pmc&term=" + this.esearchStr);
            conn = esearchURL.openConnection();
            is = conn.getInputStream();
            dbf = DocumentBuilderFactory.newInstance();
            db = dbf.newDocumentBuilder();
            xmlDoc = db.parse(is);
            pmcCount = Integer.parseInt(xmlDoc.getElementsByTagName("Count").item(0).getFirstChild().getNodeValue());
            if (this.graph == 0) {
                System.out.println(this.atStr + "," + metaCount + "," + ftCount + "," + pmCount + "," + pmcCount);
            } else {
                System.out.println(metaCount + "," + ftCount + "," + pmCount + "," + pmcCount);
            }
        }
        catch (Exception e) {
            AllProfiler.log("Error message: " + e.getMessage());
        }
    }

    public static void log(String entry) {
        System.out.println(new Date() + ":" + entry);
    }

    public static void main(String[] args) throws Exception {
        String temp;
        int i;
        String atStr = "";
        String atStrLast = "";
        String esearchStr = "";
        int graph = 0;
        boolean multiCol = false;
        Vector<String> titles = new Vector<String>();
        String[] journals = new String[4];
        if (args.length < 3) {
            System.out.println("Usage: allProfile at-file graph column");
            System.out.println("graph: 1 for output formatted for octave plotting; 0 for text file output");
            System.out.println("column: number from left to right, e.g., 0,1,3 for column 0, 1, or 3 from left to right");
            System.exit(-1);
        }
        journals[0] = "plant+cell";
        journals[1] = "plant+physiology";
        journals[2] = "genes+development";
        journals[3] = "journal+of+experimental+botany";
        int step = 200;
        for (int j = 0; j < journals.length; ++j) {
            AllProfiler.sleep(3000L);
            System.out.println("Load titles for " + journals[j]);
            URL esearchURL = new URL("http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi?db=pubmed&term=" + journals[j] + "[ta]&usehistory=y");
            URLConnection conn = esearchURL.openConnection();
            InputStream is = conn.getInputStream();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document xmlDoc = db.parse(is);
            int count = Integer.parseInt(xmlDoc.getElementsByTagName("Count").item(0).getFirstChild().getNodeValue());
            String webEnv = xmlDoc.getElementsByTagName("WebEnv").item(0).getFirstChild().getNodeValue();
            int queryKey = Integer.parseInt(xmlDoc.getElementsByTagName("QueryKey").item(0).getFirstChild().getNodeValue());
            for (int retstart = 0; retstart < count; retstart += step) {
                System.out.println("retstart: " + retstart);
                URL efetchURL = new URL("http://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?db=pubmed&WebEnv=" + webEnv + "&query_key=" + queryKey + "&retstart=" + retstart + "&retmax=" + step + "&retmode=xml");
                if (retstart + step > count && step > 1) {
                    step = 1;
                }
                conn = efetchURL.openConnection();
                is = conn.getInputStream();
                dbf = DocumentBuilderFactory.newInstance();
                db = dbf.newDocumentBuilder();
                xmlDoc = db.parse(is);
                NodeList titleNodeList = xmlDoc.getElementsByTagName("ArticleTitle");
                int numTitle = titleNodeList.getLength();
                for (i = 0; i < numTitle; ++i) {
                    Node titleNode = titleNodeList.item(i);
                    if (titleNode == null || !titleNode.hasChildNodes()) continue;
                    temp = titleNode.getFirstChild().getNodeValue();
                    titles.add(temp.toLowerCase());
                }
            }
        }
        AllProfiler.setTitles(titles);
        System.out.println("Read at file");
        BufferedReader atIn = new BufferedReader(new FileReader(args[0]));
        graph = Integer.parseInt(args[1]);
        while ((atStr = atIn.readLine()) != null) {
            if (atStr.startsWith("#")) continue;
            StringTokenizer stCol = new StringTokenizer(args[2], ",");
            if (!stCol.hasMoreTokens()) {
                System.out.println("bad column specification");
                break;
            }
            int col = Integer.parseInt(stCol.nextToken());
            StringTokenizer st1 = new StringTokenizer(atStr, "\t");
            atStr = "";
            esearchStr = "";
            i = 0;
            while (st1.hasMoreTokens()) {
                temp = st1.nextToken();
                if (i == col) {
                    atStr = atStr + "\"" + temp + "\"";
                    StringTokenizer st2 = new StringTokenizer(temp, " ");
                    esearchStr = esearchStr + st2.nextToken();
                    while (st2.hasMoreTokens()) {
                        esearchStr = esearchStr + "+";
                        esearchStr = esearchStr + st2.nextToken();
                    }
                    if (!stCol.hasMoreTokens()) break;
                    multiCol = true;
                    col = Integer.parseInt(stCol.nextToken());
                    atStr = atStr + " OR ";
                    esearchStr = esearchStr + "+or+";
                }
                ++i;
            }
            if (multiCol) {
                atStr = "(" + atStr + ")";
            }
            if (atStr.equals(atStrLast)) continue;
            AllProfiler pf = new AllProfiler(atStr, esearchStr, graph);
            pf.start();
            pf.join();
            atStrLast = atStr;
        }
        System.out.println("Done with profiling!");
    }
}

