/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.index;

import java.io.Reader;
import java.util.Hashtable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.PorterStemFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.neoref.index.NRTokenizer;

public class NRAnalyzer
extends Analyzer {
    private static final String[] STOP_WORDS = new String[]{"a", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "s", "such", "t", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with"};
    private static final Hashtable stopTable = StopFilter.makeStopTable((String[])STOP_WORDS);

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        NRTokenizer result = new NRTokenizer(reader);
        result = new StandardFilter((TokenStream)result);
        result = new LowerCaseFilter((TokenStream)result);
        result = new StopFilter((TokenStream)result, stopTable);
        result = new PorterStemFilter((TokenStream)result);
        return result;
    }
}

