/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.util.Hashtable;
import sun.tools.java.ArrayType;
import sun.tools.java.ClassType;
import sun.tools.java.CompilerError;
import sun.tools.java.Constants;
import sun.tools.java.Identifier;
import sun.tools.java.MethodType;

public class Type
implements Constants {
    private static final Hashtable typeHash = new Hashtable(231);
    protected int typeCode;
    protected String typeSig;
    public static final Type[] noArgs = new Type[0];
    public static final Type tError = new Type(13, "?");
    public static final Type tPackage = new Type(13, ".");
    public static final Type tNull = new Type(8, "*");
    public static final Type tVoid = new Type(11, "V");
    public static final Type tBoolean = new Type(0, "Z");
    public static final Type tByte = new Type(1, "B");
    public static final Type tChar = new Type(2, "C");
    public static final Type tShort = new Type(3, "S");
    public static final Type tInt = new Type(4, "I");
    public static final Type tFloat = new Type(6, "F");
    public static final Type tLong = new Type(5, "J");
    public static final Type tDouble = new Type(7, "D");
    public static final Type tObject = Type.tClass(Constants.idJavaLangObject);
    public static final Type tClassDesc = Type.tClass(Constants.idJavaLangClass);
    public static final Type tString = Type.tClass(Constants.idJavaLangString);
    public static final Type tCloneable = Type.tClass(Constants.idJavaLangCloneable);
    public static final Type tSerializable = Type.tClass(Constants.idJavaIoSerializable);

    protected Type(int n, String string) {
        this.typeCode = n;
        this.typeSig = string;
        typeHash.put(string, this);
    }

    public final String getTypeSignature() {
        return this.typeSig;
    }

    public final int getTypeCode() {
        return this.typeCode;
    }

    public final int getTypeMask() {
        return 1 << this.typeCode;
    }

    public final boolean isType(int n) {
        return this.typeCode == n;
    }

    public boolean isVoidArray() {
        if (!this.isType(9)) {
            return false;
        }
        Type type = this;
        while (type.isType(9)) {
            type = type.getElementType();
        }
        return type.isType(11);
    }

    public final boolean inMask(int n) {
        return (1 << this.typeCode & n) != 0;
    }

    public static synchronized Type tArray(Type type) {
        String string = new String("[" + type.getTypeSignature());
        Type type2 = (Type)typeHash.get(string);
        if (type2 == null) {
            type2 = new ArrayType(string, type);
        }
        return type2;
    }

    public Type getElementType() {
        throw new CompilerError("getElementType");
    }

    public int getArrayDimension() {
        return 0;
    }

    public static synchronized Type tClass(Identifier identifier) {
        if (identifier.isInner()) {
            Type type = Type.tClass(Type.mangleInnerType(identifier));
            if (type.getClassName() != identifier) {
                Type.changeClassName(type.getClassName(), identifier);
            }
            return type;
        }
        if (identifier.typeObject != null) {
            return identifier.typeObject;
        }
        String string = new String("L" + identifier.toString().replace('.', '/') + ";");
        Type type = (Type)typeHash.get(string);
        if (type == null) {
            type = new ClassType(string, identifier);
        }
        identifier.typeObject = type;
        return type;
    }

    public Identifier getClassName() {
        throw new CompilerError("getClassName:" + this);
    }

    public static Identifier mangleInnerType(Identifier identifier) {
        if (!identifier.isInner()) {
            return identifier;
        }
        Identifier identifier2 = Identifier.lookup(identifier.getFlatName().toString().replace('.', '$'));
        if (identifier2.isInner()) {
            throw new CompilerError("mangle " + identifier2);
        }
        return Identifier.lookup(identifier.getQualifier(), identifier2);
    }

    static void changeClassName(Identifier identifier, Identifier identifier2) {
        ((ClassType)Type.tClass((Identifier)identifier)).className = identifier2;
    }

    public static synchronized Type tMethod(Type type) {
        return Type.tMethod(type, noArgs);
    }

    public static synchronized Type tMethod(Type type, Type[] typeArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        int n = 0;
        while (n < typeArray.length) {
            stringBuffer.append(typeArray[n].getTypeSignature());
            ++n;
        }
        stringBuffer.append(")");
        stringBuffer.append(type.getTypeSignature());
        String string = stringBuffer.toString();
        Type type2 = (Type)typeHash.get(string);
        if (type2 == null) {
            type2 = new MethodType(string, type, typeArray);
        }
        return type2;
    }

    public Type getReturnType() {
        throw new CompilerError("getReturnType");
    }

    public Type[] getArgumentTypes() {
        throw new CompilerError("getArgumentTypes");
    }

    public static synchronized Type tType(String string) {
        Type type = (Type)typeHash.get(string);
        if (type != null) {
            return type;
        }
        switch (string.charAt(0)) {
            case '[': {
                return Type.tArray(Type.tType(string.substring(1)));
            }
            case 'L': {
                return Type.tClass(Identifier.lookup(string.substring(1, string.length() - 1).replace('/', '.')));
            }
            case '(': {
                Type[] typeArray;
                Type[] typeArray2 = new Type[8];
                int n = 0;
                int n2 = 1;
                while (string.charAt(n2) != ')') {
                    int n3 = n2;
                    while (string.charAt(n3) == '[') {
                        ++n3;
                    }
                    if (string.charAt(n3++) == 'L') {
                        while (string.charAt(n3++) != ';') {
                        }
                    }
                    if (n == typeArray2.length) {
                        typeArray = new Type[n * 2];
                        System.arraycopy(typeArray2, 0, typeArray, 0, n);
                        typeArray2 = typeArray;
                    }
                    typeArray2[n++] = Type.tType(string.substring(n2, n3));
                    n2 = n3;
                }
                typeArray = new Type[n];
                System.arraycopy(typeArray2, 0, typeArray, 0, n);
                return Type.tMethod(Type.tType(string.substring(n2 + 1)), typeArray);
            }
        }
        throw new CompilerError("invalid TypeSignature:" + string);
    }

    public boolean equalArguments(Type type) {
        return false;
    }

    public int stackSize() {
        switch (this.typeCode) {
            case 11: 
            case 13: {
                return 0;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: {
                return 1;
            }
            case 5: 
            case 7: {
                return 2;
            }
        }
        throw new CompilerError("stackSize " + this.toString());
    }

    public int getTypeCodeOffset() {
        switch (this.typeCode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return 0;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 3;
            }
            case 8: 
            case 9: 
            case 10: {
                return 4;
            }
        }
        throw new CompilerError("invalid typecode: " + this.typeCode);
    }

    public String typeString(String string, boolean bl, boolean bl2) {
        String string2 = null;
        switch (this.typeCode) {
            case 8: {
                string2 = "null";
                break;
            }
            case 11: {
                string2 = "void";
                break;
            }
            case 0: {
                string2 = "boolean";
                break;
            }
            case 1: {
                string2 = "byte";
                break;
            }
            case 2: {
                string2 = "char";
                break;
            }
            case 3: {
                string2 = "short";
                break;
            }
            case 4: {
                string2 = "int";
                break;
            }
            case 5: {
                string2 = "long";
                break;
            }
            case 6: {
                string2 = "float";
                break;
            }
            case 7: {
                string2 = "double";
                break;
            }
            case 13: {
                string2 = "<error>";
                if (this != tPackage) break;
                string2 = "<package>";
                break;
            }
            default: {
                string2 = "unknown";
            }
        }
        return string.length() > 0 ? string2 + " " + string : string2;
    }

    public String typeString(String string) {
        return this.typeString(string, false, true);
    }

    public String toString() {
        return this.typeString("", false, true);
    }
}

