/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.PathSearchingVirtualMachine;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import com.sun.tools.example.debug.tty.Commands;
import com.sun.tools.example.debug.tty.Env;
import com.sun.tools.example.debug.tty.MessageOutput;
import com.sun.tools.example.debug.tty.VMNotConnectedException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class VMConnection {
    private VirtualMachine vm;
    private Process process = null;
    private int outputCompleteCount = 0;
    private final Connector connector;
    private final Map connectorArgs;
    private final int traceFlags;

    synchronized void notifyOutputComplete() {
        ++this.outputCompleteCount;
        this.notifyAll();
    }

    synchronized void waitOutputComplete() {
        if (this.process != null) {
            while (this.outputCompleteCount < 2) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private Connector findConnector(String string) {
        List list = Bootstrap.virtualMachineManager().allConnectors();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Connector connector = (Connector)iterator.next();
            if (!connector.name().equals(string)) continue;
            return connector;
        }
        return null;
    }

    private Map parseConnectorArgs(Connector connector, String string) {
        Map map = connector.defaultArguments();
        String string2 = "(quote=[^,]+,)|(\\w+=)(((\"[^\"]*\")|('[^']*')|([^,'\"]+))+,)";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            int n = matcher.start();
            int n2 = matcher.end();
            if (n > 0) {
                throw new IllegalArgumentException(MessageOutput.format("Illegal connector argument", string));
            }
            String string3 = string.substring(n, n2);
            int n3 = string3.indexOf(61);
            String string4 = string3.substring(0, n3);
            String string5 = string3.substring(n3 + 1, string3.length() - 1);
            Connector.Argument argument = (Connector.Argument)map.get(string4);
            if (argument == null) {
                throw new IllegalArgumentException(MessageOutput.format("Argument is not defined for connector:", new Object[]{string4, connector.name()}));
            }
            argument.setValue(string5);
            string = string.substring(n2);
            matcher = pattern.matcher(string);
        }
        if (!string.equals(",") && string.length() > 0) {
            throw new IllegalArgumentException(MessageOutput.format("Illegal connector argument", string));
        }
        return map;
    }

    VMConnection(String string, int n) {
        String string2;
        String string3;
        int n2 = string.indexOf(58);
        if (n2 == -1) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(0, n2);
            string2 = string.substring(n2 + 1);
        }
        this.connector = this.findConnector(string3);
        if (this.connector == null) {
            throw new IllegalArgumentException(MessageOutput.format("No connector named:", string3));
        }
        this.connectorArgs = this.parseConnectorArgs(this.connector, string2);
        this.traceFlags = n;
    }

    synchronized VirtualMachine open() {
        if (this.connector instanceof LaunchingConnector) {
            this.vm = this.launchTarget();
        } else if (this.connector instanceof AttachingConnector) {
            this.vm = this.attachTarget();
        } else if (this.connector instanceof ListeningConnector) {
            this.vm = this.listenTarget();
        } else {
            throw new InternalError(MessageOutput.format("Invalid connect type"));
        }
        this.vm.setDebugTraceMode(this.traceFlags);
        this.setEventRequests(this.vm);
        this.resolveEventRequests();
        if (Env.getSourcePath().length() == 0) {
            if (this.vm instanceof PathSearchingVirtualMachine) {
                PathSearchingVirtualMachine pathSearchingVirtualMachine = (PathSearchingVirtualMachine)this.vm;
                Env.setSourcePath(pathSearchingVirtualMachine.classPath());
            } else {
                Env.setSourcePath(".");
            }
        }
        return this.vm;
    }

    boolean setConnectorArg(String string, String string2) {
        if (this.vm != null) {
            return false;
        }
        Connector.Argument argument = (Connector.Argument)this.connectorArgs.get(string);
        if (argument == null) {
            return false;
        }
        argument.setValue(string2);
        return true;
    }

    String connectorArg(String string) {
        Connector.Argument argument = (Connector.Argument)this.connectorArgs.get(string);
        if (argument == null) {
            return "";
        }
        return argument.value();
    }

    public synchronized VirtualMachine vm() {
        if (this.vm == null) {
            throw new VMNotConnectedException();
        }
        return this.vm;
    }

    boolean isOpen() {
        return this.vm != null;
    }

    boolean isLaunch() {
        return this.connector instanceof LaunchingConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeVM() {
        try {
            if (this.vm != null) {
                this.vm.dispose();
                this.vm = null;
            }
        }
        finally {
            if (this.process != null) {
                this.process.destroy();
                this.process = null;
            }
            this.waitOutputComplete();
        }
    }

    private void setEventRequests(VirtualMachine virtualMachine) {
        EventRequestManager eventRequestManager = virtualMachine.eventRequestManager();
        Commands commands = new Commands();
        commands.commandCatchException(new StringTokenizer("uncaught java.lang.Throwable"));
        ThreadStartRequest threadStartRequest = eventRequestManager.createThreadStartRequest();
        threadStartRequest.enable();
        ThreadDeathRequest threadDeathRequest = eventRequestManager.createThreadDeathRequest();
        threadDeathRequest.enable();
    }

    private void resolveEventRequests() {
        Env.specList.resolveAll();
    }

    private void dumpStream(InputStream inputStream) throws IOException {
        int n;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((n = bufferedReader.read()) != -1) {
            MessageOutput.printDirect((char)n);
        }
    }

    private void displayRemoteOutput(final InputStream inputStream) {
        Thread thread = new Thread("output reader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        VMConnection.this.dumpStream(inputStream);
                    }
                    catch (IOException iOException) {
                        MessageOutput.fatalError("Failed reading output");
                        Object var3_2 = null;
                        VMConnection.this.notifyOutputComplete();
                    }
                    Object var3_1 = null;
                    VMConnection.this.notifyOutputComplete();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    VMConnection.this.notifyOutputComplete();
                    throw throwable;
                }
            }
        };
        thread.setPriority(9);
        thread.start();
    }

    private void dumpFailedLaunchInfo(Process process) {
        try {
            this.dumpStream(process.getErrorStream());
            this.dumpStream(process.getInputStream());
        }
        catch (IOException iOException) {
            MessageOutput.println("Unable to display process output:", iOException.getMessage());
        }
    }

    private VirtualMachine launchTarget() {
        LaunchingConnector launchingConnector = (LaunchingConnector)this.connector;
        try {
            VirtualMachine virtualMachine = launchingConnector.launch(this.connectorArgs);
            this.process = virtualMachine.process();
            this.displayRemoteOutput(this.process.getErrorStream());
            this.displayRemoteOutput(this.process.getInputStream());
            return virtualMachine;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            MessageOutput.fatalError("Unable to launch target VM.");
        }
        catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {
            illegalConnectorArgumentsException.printStackTrace();
            MessageOutput.fatalError("Internal debugger error.");
        }
        catch (VMStartException vMStartException) {
            MessageOutput.println("vmstartexception", vMStartException.getMessage());
            MessageOutput.println();
            this.dumpFailedLaunchInfo(vMStartException.process());
            MessageOutput.fatalError("Target VM failed to initialize.");
        }
        return null;
    }

    private VirtualMachine attachTarget() {
        AttachingConnector attachingConnector = (AttachingConnector)this.connector;
        try {
            return attachingConnector.attach(this.connectorArgs);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            MessageOutput.fatalError("Unable to attach to target VM.");
        }
        catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {
            illegalConnectorArgumentsException.printStackTrace();
            MessageOutput.fatalError("Internal debugger error.");
        }
        return null;
    }

    private VirtualMachine listenTarget() {
        ListeningConnector listeningConnector = (ListeningConnector)this.connector;
        try {
            String string = listeningConnector.startListening(this.connectorArgs);
            MessageOutput.println("Listening at address:", string);
            this.vm = listeningConnector.accept(this.connectorArgs);
            listeningConnector.stopListening(this.connectorArgs);
            return this.vm;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            MessageOutput.fatalError("Unable to attach to target VM.");
        }
        catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {
            illegalConnectorArgumentsException.printStackTrace();
            MessageOutput.fatalError("Internal debugger error.");
        }
        return null;
    }
}

