/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public final class StopFilter
extends TokenFilter {
    private Hashtable table;

    public StopFilter(TokenStream tokenStream, String[] stringArray) {
        this.input = tokenStream;
        this.table = StopFilter.makeStopTable(stringArray);
    }

    public StopFilter(TokenStream tokenStream, Hashtable hashtable) {
        this.input = tokenStream;
        this.table = hashtable;
    }

    public static final Hashtable makeStopTable(String[] stringArray) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            hashtable.put(stringArray[n], stringArray[n]);
            ++n;
        }
        return hashtable;
    }

    public final Token next() throws IOException {
        Token token = this.input.next();
        while (token != null) {
            if (this.table.get(token.termText) == null) {
                return token;
            }
            token = this.input.next();
        }
        return null;
    }
}

