/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.jaxp;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.crimson.jaxp.DefaultValidationErrorHandler;
import org.apache.crimson.parser.XMLReaderImpl;
import org.xml.sax.HandlerBase;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderAdapter;

public class SAXParserImpl
extends SAXParser {
    private XMLReader xmlReader = new XMLReaderImpl();
    private Parser parser = null;
    private boolean validating = false;
    private boolean namespaceAware = false;

    SAXParserImpl(SAXParserFactory spf, Hashtable features) throws SAXException {
        this.validating = spf.isValidating();
        String validation = "http://xml.org/sax/features/validation";
        if (this.validating) {
            this.xmlReader.setErrorHandler(new DefaultValidationErrorHandler());
        }
        this.xmlReader.setFeature(validation, this.validating);
        this.namespaceAware = spf.isNamespaceAware();
        String namespaces = "http://xml.org/sax/features/namespaces";
        this.xmlReader.setFeature(namespaces, this.namespaceAware);
        this.setFeatures(features);
    }

    private void setFeatures(Hashtable features) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (features != null) {
            Enumeration e = features.keys();
            while (e.hasMoreElements()) {
                String feature = (String)e.nextElement();
                boolean value = (Boolean)features.get(feature);
                this.xmlReader.setFeature(feature, value);
            }
        }
    }

    public Parser getParser() throws SAXException {
        if (this.parser == null) {
            this.parser = new XMLReaderAdapter(this.xmlReader);
            this.parser.setDocumentHandler(new HandlerBase());
        }
        return this.parser;
    }

    public XMLReader getXMLReader() {
        return this.xmlReader;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.xmlReader.setProperty(name, value);
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.xmlReader.getProperty(name);
    }
}

