/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.ttf;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.pdfbox.cos.COSStream;
import org.pdfbox.ttf.TTFDataStream;

public class RAFDataStream
extends RandomAccessFile
implements TTFDataStream {
    public RAFDataStream(String name, String mode) throws FileNotFoundException {
        super(name, mode);
    }

    public RAFDataStream(File file, String mode) throws FileNotFoundException {
        super(file, mode);
    }

    public float read32Fixed() throws IOException {
        float retval = 0.0f;
        retval = this.readShort();
        return retval += (float)(this.readUnsignedShort() / 65536);
    }

    public String readString(int length) throws IOException {
        return this.readString(length, "ISO-8859-1");
    }

    public String readString(int length, String charset) throws IOException {
        byte[] buffer = this.read(length);
        return new String(buffer, charset);
    }

    public byte[] read(int numberOfBytes) throws IOException {
        byte[] data = new byte[numberOfBytes];
        int amountRead = 0;
        for (int totalAmountRead = 0; (amountRead = super.read(data, totalAmountRead, numberOfBytes - totalAmountRead)) != -1 && totalAmountRead < numberOfBytes; totalAmountRead += amountRead) {
        }
        return data;
    }

    public long readUnsignedInt() throws IOException {
        long byte1 = this.read();
        long byte2 = this.read();
        long byte3 = this.read();
        long byte4 = this.read();
        if (byte4 < 0L) {
            throw new EOFException();
        }
        return (byte1 << 24) + (byte2 << 16) + (byte3 << 8) + (byte4 << 0);
    }

    public short readSignedShort() throws IOException {
        return super.readShort();
    }

    public int readSignedByte() throws IOException {
        return this.read() - 255;
    }

    public Calendar readInternationalDate() throws IOException {
        long secondsSince1904 = super.readLong();
        GregorianCalendar cal = new GregorianCalendar(1904, 0, 1);
        long millisFor1904 = cal.getTimeInMillis();
        cal.setTimeInMillis(millisFor1904 += secondsSince1904 * 1000L);
        return cal;
    }

    public int[] readUnsignedShortArray(int length) throws IOException {
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readUnsignedShort();
        }
        return array;
    }

    public long getCurrentPosition() throws IOException {
        return super.getFilePointer();
    }

    public COSStream getCOSStream() {
        COSStream retval = null;
        retval = new COSStream(this);
        return retval;
    }
}

