/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.common.COSArrayList;
import org.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.pdfbox.pdmodel.interactive.form.PDCheckbox;
import org.pdfbox.pdmodel.interactive.form.PDChoiceButton;

public class PDRadioCollection
extends PDChoiceButton {
    public static final int FLAG_RADIOS_IN_UNISON = 0x2000000;

    public PDRadioCollection(PDAcroForm theAcroForm, COSDictionary field) {
        super(theAcroForm, field);
    }

    public void setRadiosInUnison(boolean radiosInUnison) {
        this.setFfFlag(0x2000000, radiosInUnison);
    }

    public boolean isRadiosInUnison() {
        return this.getFfFlag(0x2000000);
    }

    public void setValue(String value) {
        this.getDictionary().setString("V", value);
        List kids = this.getKids();
        for (int i = 0; i < kids.size(); ++i) {
            PDCheckbox btn = (PDCheckbox)kids.get(i);
            if (btn.getOnValue().equals(value)) {
                btn.check();
                continue;
            }
            btn.unCheck();
        }
    }

    public String getValue() throws IOException {
        String retval = null;
        List kids = this.getKids();
        for (int i = 0; i < kids.size(); ++i) {
            PDCheckbox btn = (PDCheckbox)kids.get(i);
            if (!btn.isChecked()) continue;
            retval = btn.getOnValue();
        }
        return retval;
    }

    public List getKids() {
        COSArrayList retval = null;
        COSArray kids = (COSArray)this.getDictionary().getDictionaryObject(COSName.KIDS);
        if (kids != null) {
            ArrayList<PDCheckbox> kidsList = new ArrayList<PDCheckbox>();
            for (int i = 0; i < kids.size(); ++i) {
                kidsList.add(new PDCheckbox(this.getAcroForm(), (COSDictionary)kids.getObject(i)));
            }
            retval = new COSArrayList(kidsList, kids);
        }
        return retval;
    }
}

