/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.graphics.xobject;

import java.io.IOException;
import java.util.List;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSStream;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.common.PDStream;
import org.pdfbox.pdmodel.graphics.xobject.PDJpeg;
import org.pdfbox.pdmodel.graphics.xobject.PDPixelMap;

public abstract class PDXObject
implements COSObjectable {
    private COSDictionary xobject;

    public PDXObject(COSDictionary xobj) {
        this.xobject = xobj;
    }

    public COSBase getCOSObject() {
        return this.xobject;
    }

    public static PDXObject createXObject(COSBase xobject) throws IOException {
        PDXObject retval = null;
        if (xobject != null) {
            if (xobject instanceof COSStream) {
                COSStream stream = (COSStream)xobject;
                PDStream image = new PDStream(stream);
                List filters = image.getFilters();
                if (filters.contains(COSName.DCT_DECODE.getName())) {
                    return new PDJpeg(image);
                }
                if (filters.contains(COSName.JPX_DECODE.getName())) {
                    return null;
                }
                return new PDPixelMap(image);
            }
            throw new IOException("Unknown xobject type:" + xobject.getClass().getName());
        }
        retval = null;
        return retval;
    }
}

