/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSStream;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdfviewer.PageDrawer;
import org.pdfbox.pdmodel.PDPageNode;
import org.pdfbox.pdmodel.PDResources;
import org.pdfbox.pdmodel.common.COSArrayList;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.common.PDMetadata;
import org.pdfbox.pdmodel.common.PDRectangle;
import org.pdfbox.pdmodel.common.PDStream;
import org.pdfbox.pdmodel.interactive.action.PDPageAdditionalActions;
import org.pdfbox.pdmodel.interactive.pagenavigation.PDThreadBead;
import org.pdfbox.util.DateConverter;

public class PDPage
implements COSObjectable {
    private COSDictionary page;
    public static final PDRectangle PAGE_SIZE_LETTER = new PDRectangle(612.0f, 792.0f);

    public PDPage() {
        this.page = new COSDictionary();
        this.page.setItem(COSName.getPDFName("Type"), (COSBase)COSName.getPDFName("Page"));
        this.setMediaBox(PAGE_SIZE_LETTER);
    }

    public PDPage(COSDictionary pageDic) {
        this.page = pageDic;
    }

    public COSBase getCOSObject() {
        return this.page;
    }

    public COSDictionary getCOSDictionary() {
        return this.page;
    }

    public PDPageNode getParent() {
        PDPageNode parent = null;
        COSDictionary parentDic = (COSDictionary)this.page.getDictionaryObject(COSName.PARENT);
        if (parentDic != null) {
            parent = new PDPageNode(parentDic);
        }
        return parent;
    }

    public void setParent(PDPageNode parent) {
        this.page.setItem(COSName.PARENT, (COSBase)parent.getDictionary());
    }

    public void updateLastModified() {
        DateConverter converter = new DateConverter();
        GregorianCalendar today = new GregorianCalendar();
        this.page.setItem(COSName.getPDFName("LastModified"), (COSBase)new COSString(converter.toString(today)));
    }

    public Calendar getLastModified() throws IOException {
        Calendar retval = null;
        COSString date = (COSString)this.page.getDictionaryObject(COSName.getPDFName("LastModified"));
        if (date != null) {
            DateConverter converter = new DateConverter();
            retval = converter.toCalendar(date.getString());
        }
        return retval;
    }

    public PDResources getResources() {
        PDResources retval = null;
        COSDictionary resources = (COSDictionary)this.page.getDictionaryObject(COSName.RESOURCES);
        if (resources != null) {
            retval = new PDResources(resources);
        }
        return retval;
    }

    public PDResources findResources() {
        PDResources retval = this.getResources();
        PDPageNode parent = this.getParent();
        if (retval == null && parent != null) {
            retval = parent.findResources();
        }
        return retval;
    }

    public void setResources(PDResources resources) {
        if (resources == null) {
            this.page.removeItem(COSName.RESOURCES);
        } else {
            this.page.setItem(COSName.RESOURCES, (COSBase)resources.getCOSDictionary());
        }
    }

    public PDRectangle getMediaBox() {
        PDRectangle retval = null;
        COSArray array = (COSArray)this.page.getDictionaryObject(COSName.getPDFName("MediaBox"));
        if (array != null) {
            retval = new PDRectangle(array);
        }
        return retval;
    }

    public PDRectangle findMediaBox() {
        PDRectangle retval = this.getMediaBox();
        PDPageNode parent = this.getParent();
        if (retval == null && parent != null) {
            retval = parent.findMediaBox();
        }
        return retval;
    }

    public void setMediaBox(PDRectangle mediaBox) {
        if (mediaBox == null) {
            this.page.removeItem(COSName.getPDFName("MediaBox"));
        } else {
            this.page.setItem(COSName.getPDFName("MediaBox"), (COSBase)mediaBox.getCOSArray());
        }
    }

    public PDRectangle getCropBox() {
        PDRectangle retval = null;
        COSArray array = (COSArray)this.page.getDictionaryObject(COSName.getPDFName("CropBox"));
        if (array != null) {
            retval = new PDRectangle(array);
        }
        return retval;
    }

    public PDRectangle findCropBox() {
        PDRectangle retval = this.getCropBox();
        PDPageNode parent = this.getParent();
        if (retval == null && parent != null) {
            retval = this.findParentCropBox(parent);
        }
        if (retval == null) {
            retval = this.findMediaBox();
        }
        return retval;
    }

    private PDRectangle findParentCropBox(PDPageNode node) {
        PDRectangle rect = node.getCropBox();
        PDPageNode parent = node.getParent();
        if (rect == null && parent != null) {
            rect = this.findParentCropBox(parent);
        }
        return rect;
    }

    public void setCropBox(PDRectangle cropBox) {
        if (cropBox == null) {
            this.page.removeItem(COSName.getPDFName("CropBox"));
        } else {
            this.page.setItem(COSName.getPDFName("CropBox"), (COSBase)cropBox.getCOSArray());
        }
    }

    public PDRectangle getBleedBox() {
        PDRectangle retval = null;
        COSArray array = (COSArray)this.page.getDictionaryObject(COSName.getPDFName("BleedBox"));
        retval = array != null ? new PDRectangle(array) : this.findCropBox();
        return retval;
    }

    public void setBleedBox(PDRectangle bleedBox) {
        if (bleedBox == null) {
            this.page.removeItem(COSName.getPDFName("BleedBox"));
        } else {
            this.page.setItem(COSName.getPDFName("BleedBox"), (COSBase)bleedBox.getCOSArray());
        }
    }

    public PDRectangle getTrimBox() {
        PDRectangle retval = null;
        COSArray array = (COSArray)this.page.getDictionaryObject(COSName.getPDFName("TrimBox"));
        retval = array != null ? new PDRectangle(array) : this.findCropBox();
        return retval;
    }

    public void setTrimBox(PDRectangle trimBox) {
        if (trimBox == null) {
            this.page.removeItem(COSName.getPDFName("TrimBox"));
        } else {
            this.page.setItem(COSName.getPDFName("TrimBox"), (COSBase)trimBox.getCOSArray());
        }
    }

    public PDRectangle getArtBox() {
        PDRectangle retval = null;
        COSArray array = (COSArray)this.page.getDictionaryObject(COSName.getPDFName("ArtBox"));
        retval = array != null ? new PDRectangle(array) : this.findCropBox();
        return retval;
    }

    public void setArtBox(PDRectangle artBox) {
        if (artBox == null) {
            this.page.removeItem(COSName.getPDFName("ArtBox"));
        } else {
            this.page.setItem(COSName.getPDFName("ArtBox"), (COSBase)artBox.getCOSArray());
        }
    }

    public Integer getRotation() {
        Integer retval = null;
        COSNumber value = (COSNumber)this.page.getDictionaryObject(COSName.getPDFName("Rotate"));
        if (value != null) {
            retval = new Integer(value.intValue());
        }
        return retval;
    }

    public int findRotation() {
        int retval = 0;
        Integer rotation = this.getRotation();
        if (rotation != null) {
            retval = rotation;
        } else {
            PDPageNode parent = this.getParent();
            if (parent != null) {
                retval = parent.findRotation();
            }
        }
        return retval;
    }

    public void setRotation(int rotation) {
        this.page.setItem(COSName.getPDFName("Rotate"), (COSBase)new COSInteger(rotation));
    }

    public PDStream getContents() throws IOException {
        return PDStream.createFromCOS(this.page.getDictionaryObject(COSName.CONTENTS));
    }

    public void setContents(PDStream contents) {
        this.page.setItem(COSName.CONTENTS, (COSObjectable)contents);
    }

    public List getThreadBeads() {
        COSArray beads = (COSArray)this.page.getDictionaryObject("B");
        if (beads == null) {
            beads = new COSArray();
        }
        ArrayList<PDThreadBead> pdObjects = new ArrayList<PDThreadBead>();
        for (int i = 0; i < beads.size(); ++i) {
            pdObjects.add(new PDThreadBead((COSDictionary)beads.getObject(i)));
        }
        return new COSArrayList(pdObjects, beads);
    }

    public void setThreadBeads(List beads) {
        this.page.setItem("B", (COSBase)COSArrayList.converterToCOSArray(beads));
    }

    public PDMetadata getMetadata() {
        PDMetadata retval = null;
        COSStream stream = (COSStream)this.page.getDictionaryObject("Metadata");
        if (stream != null) {
            retval = new PDMetadata(stream);
        }
        return retval;
    }

    public void setMetadata(PDMetadata meta) {
        this.page.setItem("Metadata", (COSObjectable)meta);
    }

    public BufferedImage convertToImage() throws IOException {
        PDRectangle mBox = this.getMediaBox();
        BufferedImage retval = new BufferedImage((int)mBox.getWidth() * 2, (int)mBox.getHeight() * 2, 13);
        Graphics2D graphics = (Graphics2D)retval.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.scale(2.0, 2.0);
        graphics.fillRect(0, 0, (int)mBox.getWidth(), (int)mBox.getHeight());
        PageDrawer drawer = new PageDrawer();
        drawer.drawPage(graphics, this, mBox.createDimension());
        return retval;
    }

    public PDPageAdditionalActions getActions() {
        COSDictionary addAct = (COSDictionary)this.page.getDictionaryObject("AA");
        if (addAct == null) {
            addAct = new COSDictionary();
            this.page.setItem("AA", (COSBase)addAct);
        }
        return new PDPageAdditionalActions(addAct);
    }

    public void setActions(PDPageAdditionalActions actions) {
        this.page.setItem("AA", (COSObjectable)actions);
    }
}

