/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdfwriter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSBoolean;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.cos.COSFloat;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNull;
import org.pdfbox.cos.COSObject;
import org.pdfbox.cos.COSStream;
import org.pdfbox.cos.COSString;
import org.pdfbox.cos.ICOSVisitor;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.pdfwriter.COSStandardOutputStream;
import org.pdfbox.pdfwriter.COSWriterXRefEntry;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.persistence.util.COSObjectKey;

public class COSWriter
implements ICOSVisitor {
    private static Logger log = Logger.getLogger((Class)(class$org$pdfbox$pdfwriter$COSWriter == null ? (class$org$pdfbox$pdfwriter$COSWriter = COSWriter.class$("org.pdfbox.pdfwriter.COSWriter")) : class$org$pdfbox$pdfwriter$COSWriter));
    public static final byte[] DICT_OPEN = "<<".getBytes();
    public static final byte[] DICT_CLOSE = ">>".getBytes();
    public static final byte[] SPACE = " ".getBytes();
    public static final byte[] COMMENT = "%".getBytes();
    public static final byte[] VERSION = "PDF-1.4".getBytes();
    public static final byte[] GARBAGE = new byte[]{-10, -28, -4, -33};
    public static final byte[] EOF = "%%EOF".getBytes();
    public static final byte[] REFERENCE = "R".getBytes();
    public static final byte[] XREF = "xref".getBytes();
    public static final byte[] XREF_FREE = "f".getBytes();
    public static final byte[] XREF_USED = "n".getBytes();
    public static final byte[] TRAILER = "trailer".getBytes();
    public static final byte[] STARTXREF = "startxref".getBytes();
    public static final byte[] OBJ = "obj".getBytes();
    public static final byte[] ENDOBJ = "endobj".getBytes();
    public static final byte[] ARRAY_OPEN = "[".getBytes();
    public static final byte[] ARRAY_CLOSE = "]".getBytes();
    public static final byte[] STREAM = "stream".getBytes();
    public static final byte[] ENDSTREAM = "endstream".getBytes();
    private NumberFormat formatXrefOffset = new DecimalFormat("0000000000");
    private NumberFormat formatXrefGeneration = new DecimalFormat("00000");
    private NumberFormat formatDecimal = NumberFormat.getNumberInstance(Locale.US);
    private OutputStream output;
    private COSStandardOutputStream standardOutput;
    private long startxref = 0L;
    private long number = 0L;
    private Map objectKeys = new Hashtable();
    private List xRefEntries = new ArrayList();
    private List objectsToWrite = new ArrayList();
    private Set writtenObjects = new HashSet();
    private Set actualsAdded = new HashSet();
    static /* synthetic */ Class class$org$pdfbox$pdfwriter$COSWriter;

    public COSWriter(OutputStream os) {
        this.setOutput(os);
        this.setStandardOutput(new COSStandardOutputStream(this.getOutput()));
        this.formatDecimal.setMaximumFractionDigits(10);
        this.formatDecimal.setGroupingUsed(false);
    }

    protected void addXRefEntry(COSWriterXRefEntry entry) {
        this.getXRefEntries().add(entry);
    }

    public void close() throws IOException {
        if (this.getStandardOutput() != null) {
            this.getStandardOutput().close();
        }
        if (this.getOutput() != null) {
            this.getOutput().close();
        }
    }

    protected long getNumber() {
        return this.number;
    }

    public Map getObjectKeys() {
        return this.objectKeys;
    }

    protected OutputStream getOutput() {
        return this.output;
    }

    protected COSStandardOutputStream getStandardOutput() {
        return this.standardOutput;
    }

    protected long getStartxref() {
        return this.startxref;
    }

    protected List getXRefEntries() {
        return this.xRefEntries;
    }

    protected void setNumber(long newNumber) {
        this.number = newNumber;
    }

    private void setOutput(OutputStream newOutput) {
        this.output = newOutput;
    }

    private void setStandardOutput(COSStandardOutputStream newStandardOutput) {
        this.standardOutput = newStandardOutput;
    }

    protected void setStartxref(long newStartxref) {
        this.startxref = newStartxref;
    }

    protected void doWriteBody(COSDocument doc) throws IOException, COSVisitorException {
        COSDictionary trailer = doc.getTrailer();
        COSDictionary root = (COSDictionary)trailer.getDictionaryObject(COSName.ROOT);
        COSDictionary info = (COSDictionary)trailer.getDictionaryObject(COSName.getPDFName("Info"));
        COSDictionary encrypt = (COSDictionary)trailer.getDictionaryObject(COSName.getPDFName("Encrypt"));
        if (root != null) {
            this.addObjectToWrite(root);
        }
        if (info != null) {
            this.addObjectToWrite(info);
        }
        if (encrypt != null) {
            this.addObjectToWrite(encrypt);
        }
        while (this.objectsToWrite.size() > 0) {
            COSBase nextObject = (COSBase)this.objectsToWrite.remove(0);
            this.doWriteObject(nextObject);
        }
    }

    private void addObjectToWrite(COSBase object) {
        COSBase actual = object;
        if (actual instanceof COSObject) {
            actual = ((COSObject)actual).getObject();
        }
        if (!(this.writtenObjects.contains(object) || this.objectsToWrite.contains(object) || this.actualsAdded.contains(actual))) {
            this.objectsToWrite.add(object);
            if (actual != null) {
                this.actualsAdded.add(actual);
            }
        }
    }

    public void doWriteObject(COSBase obj) throws COSVisitorException {
        try {
            this.writtenObjects.add(obj);
            COSObjectKey key = this.getObjectKey(obj);
            this.addXRefEntry(new COSWriterXRefEntry(this.getStandardOutput().getPos(), obj, key));
            this.getStandardOutput().write(String.valueOf(key.getNumber()).getBytes());
            this.getStandardOutput().write(SPACE);
            this.getStandardOutput().write(String.valueOf(key.getGeneration()).getBytes());
            this.getStandardOutput().write(SPACE);
            this.getStandardOutput().write(OBJ);
            this.getStandardOutput().writeEOL();
            obj.accept(this);
            this.getStandardOutput().writeEOL();
            this.getStandardOutput().write(ENDOBJ);
            this.getStandardOutput().writeEOL();
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    protected void doWriteHeader(COSDocument doc) throws IOException {
        this.getStandardOutput().write(doc.getHeaderString().getBytes());
        this.getStandardOutput().writeEOL();
        this.getStandardOutput().write(COMMENT);
        this.getStandardOutput().write(GARBAGE);
        this.getStandardOutput().writeEOL();
    }

    protected void doWriteTrailer(COSDocument doc) throws IOException, COSVisitorException {
        this.getStandardOutput().write(TRAILER);
        this.getStandardOutput().writeEOL();
        COSDictionary trailer = doc.getTrailer();
        Collections.sort(this.getXRefEntries());
        COSWriterXRefEntry lastEntry = (COSWriterXRefEntry)this.getXRefEntries().get(this.getXRefEntries().size() - 1);
        trailer.setInt(COSName.getPDFName("Size"), (int)lastEntry.getKey().getNumber() + 1);
        trailer.removeItem(COSName.PREV);
        trailer.accept(this);
        this.getStandardOutput().write(STARTXREF);
        this.getStandardOutput().writeEOL();
        this.getStandardOutput().write(String.valueOf(this.getStartxref()).getBytes());
        this.getStandardOutput().writeEOL();
        this.getStandardOutput().write(EOF);
    }

    protected void doWriteXRef(COSDocument doc) throws IOException {
        Collections.sort(this.getXRefEntries());
        COSWriterXRefEntry lastEntry = (COSWriterXRefEntry)this.getXRefEntries().get(this.getXRefEntries().size() - 1);
        this.setStartxref(this.getStandardOutput().getPos());
        this.getStandardOutput().write(XREF);
        this.getStandardOutput().writeEOL();
        this.getStandardOutput().write(String.valueOf(0).getBytes());
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(String.valueOf(lastEntry.getKey().getNumber() + 1L).getBytes());
        this.getStandardOutput().writeEOL();
        String offset = this.formatXrefOffset.format(0L);
        String generation = this.formatXrefGeneration.format(65535L);
        this.getStandardOutput().write(offset.getBytes());
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(generation.getBytes());
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(XREF_FREE);
        this.getStandardOutput().writeCRLF();
        long lastObjectNumber = 0L;
        Iterator i = this.getXRefEntries().iterator();
        while (i.hasNext()) {
            COSWriterXRefEntry entry = (COSWriterXRefEntry)i.next();
            while (lastObjectNumber < entry.getKey().getNumber() - 1L) {
                offset = this.formatXrefOffset.format(0L);
                generation = this.formatXrefGeneration.format(65535L);
                this.getStandardOutput().write(offset.getBytes());
                this.getStandardOutput().write(SPACE);
                this.getStandardOutput().write(generation.getBytes());
                this.getStandardOutput().write(SPACE);
                this.getStandardOutput().write(XREF_FREE);
                this.getStandardOutput().writeCRLF();
                ++lastObjectNumber;
            }
            lastObjectNumber = entry.getKey().getNumber();
            offset = this.formatXrefOffset.format(entry.getOffset());
            generation = this.formatXrefGeneration.format(entry.getKey().getGeneration());
            this.getStandardOutput().write(offset.getBytes());
            this.getStandardOutput().write(SPACE);
            this.getStandardOutput().write(generation.getBytes());
            this.getStandardOutput().write(SPACE);
            this.getStandardOutput().write(entry.isFree() ? XREF_FREE : XREF_USED);
            this.getStandardOutput().writeCRLF();
        }
    }

    public COSObjectKey getObjectKey(COSBase obj) {
        COSBase actual = obj;
        if (actual instanceof COSObject) {
            actual = ((COSObject)obj).getObject();
        }
        COSObjectKey key = null;
        if (actual != null) {
            key = (COSObjectKey)this.objectKeys.get(actual);
        }
        if (key == null) {
            key = (COSObjectKey)this.objectKeys.get(obj);
        }
        if (key == null) {
            this.setNumber(this.getNumber() + 1L);
            key = new COSObjectKey(this.getNumber(), 0L);
            this.objectKeys.put(obj, key);
            if (actual != null) {
                this.objectKeys.put(actual, key);
            }
        }
        return key;
    }

    public Object visitFromArray(COSArray obj) throws COSVisitorException {
        try {
            int count = 0;
            this.getStandardOutput().write(ARRAY_OPEN);
            Iterator i = obj.iterator();
            while (i.hasNext()) {
                COSBase current = (COSBase)i.next();
                if (current instanceof COSDictionary || current instanceof COSStream || current instanceof COSObject) {
                    this.addObjectToWrite(current);
                    this.writeReference(current);
                } else if (current == null) {
                    COSNull.NULL.accept(this);
                } else {
                    current.accept(this);
                }
                ++count;
                if (!i.hasNext()) continue;
                if (count % 10 == 0) {
                    this.getStandardOutput().writeEOL();
                    continue;
                }
                this.getStandardOutput().write(SPACE);
            }
            this.getStandardOutput().write(ARRAY_CLOSE);
            this.getStandardOutput().writeEOL();
            return null;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    public Object visitFromBoolean(COSBoolean obj) throws COSVisitorException {
        try {
            obj.writePDF(this.getStandardOutput());
            return null;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    public Object visitFromDictionary(COSDictionary obj) throws COSVisitorException {
        try {
            this.getStandardOutput().write(DICT_OPEN);
            this.getStandardOutput().writeEOL();
            Iterator i = obj.keyList().iterator();
            while (i.hasNext()) {
                COSName name = (COSName)i.next();
                COSBase value = obj.getItem(name);
                if (value == null) continue;
                if (value != null) {
                    name.accept(this);
                    this.getStandardOutput().write(SPACE);
                }
                if (value == null) {
                    log.debug((Object)"Value is null");
                } else if (value instanceof COSDictionary || value instanceof COSStream || value instanceof COSObject) {
                    this.addObjectToWrite(value);
                    this.writeReference(value);
                } else {
                    value.accept(this);
                }
                this.getStandardOutput().writeEOL();
            }
            this.getStandardOutput().write(DICT_CLOSE);
            this.getStandardOutput().writeEOL();
            return null;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    public Object visitFromDocument(COSDocument doc) throws COSVisitorException {
        try {
            this.doWriteHeader(doc);
            this.doWriteBody(doc);
            this.doWriteXRef(doc);
            this.doWriteTrailer(doc);
            return null;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    public Object visitFromFloat(COSFloat obj) throws COSVisitorException {
        try {
            obj.writePDF(this.getStandardOutput());
            return null;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    public Object visitFromInt(COSInteger obj) throws COSVisitorException {
        try {
            obj.writePDF(this.getStandardOutput());
            return null;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    public Object visitFromName(COSName obj) throws COSVisitorException {
        try {
            obj.writePDF(this.getStandardOutput());
            return null;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    public Object visitFromNull(COSNull obj) throws COSVisitorException {
        try {
            obj.writePDF(this.getStandardOutput());
            return null;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    public void writeReference(COSBase obj) throws COSVisitorException {
        try {
            COSObjectKey key = this.getObjectKey(obj);
            this.getStandardOutput().write(String.valueOf(key.getNumber()).getBytes());
            this.getStandardOutput().write(SPACE);
            this.getStandardOutput().write(String.valueOf(key.getGeneration()).getBytes());
            this.getStandardOutput().write(SPACE);
            this.getStandardOutput().write(REFERENCE);
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    public Object visitFromStream(COSStream obj) throws COSVisitorException {
        try {
            InputStream input = obj.getFilteredStream();
            COSObject lengthObject = new COSObject(null);
            obj.setItem(COSName.LENGTH, (COSBase)lengthObject);
            this.visitFromDictionary(obj);
            this.getStandardOutput().write(STREAM);
            this.getStandardOutput().writeCRLF();
            byte[] buffer = new byte[1024];
            int amountRead = 0;
            int totalAmountWritten = 0;
            while ((amountRead = input.read(buffer, 0, 1024)) != -1) {
                this.getStandardOutput().write(buffer, 0, amountRead);
                totalAmountWritten += amountRead;
            }
            lengthObject.setObject(new COSInteger(totalAmountWritten));
            this.getStandardOutput().writeCRLF();
            this.getStandardOutput().write(ENDSTREAM);
            this.getStandardOutput().writeEOL();
            return null;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    public Object visitFromString(COSString obj) throws COSVisitorException {
        try {
            obj.writePDF(this.getStandardOutput());
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
        return null;
    }

    public void write(COSDocument doc) throws COSVisitorException {
        COSDictionary trailer = doc.getTrailer();
        COSArray idArray = (COSArray)trailer.getDictionaryObject("ID");
        if (idArray == null) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(Long.toString(System.currentTimeMillis()).getBytes());
                COSDictionary info = (COSDictionary)trailer.getDictionaryObject("Info");
                if (info != null) {
                    Iterator values = info.getValues().iterator();
                    while (values.hasNext()) {
                        md.update(values.next().toString().getBytes());
                    }
                }
                idArray = new COSArray();
                COSString id = new COSString(md.digest());
                idArray.add(id);
                idArray.add(id);
                trailer.setItem("ID", (COSBase)idArray);
            }
            catch (NoSuchAlgorithmException e) {
                throw new COSVisitorException(e);
            }
        }
        doc.accept(this);
    }

    public void write(PDDocument doc) throws COSVisitorException {
        this.write(doc.getDocument());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

