/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.util;

import java.util.HashMap;
import java.util.Map;
import org.pdfbox.cos.COSDictionary;

public class PDFOperator {
    private String theOperator;
    private byte[] imageData;
    private COSDictionary imageParameters;
    private static Map operators = new HashMap();

    private PDFOperator(String aOperator) {
        this.theOperator = aOperator;
        if (aOperator.startsWith("/")) {
            throw new RuntimeException("Operators are not allowed to start with / '" + aOperator + "'");
        }
        if (this.theOperator.equals("BI")) {
            this.imageParameters = new COSDictionary();
        }
    }

    public static PDFOperator getOperator(String operator) {
        PDFOperator operation = null;
        if (operator.equals("ID") || operator.equals("BI")) {
            operation = new PDFOperator(operator);
        } else {
            operation = (PDFOperator)operators.get(operator);
            if (operation == null) {
                operation = new PDFOperator(operator);
                operators.put(operator, operation);
            }
        }
        return operation;
    }

    public String getOperation() {
        return this.theOperator;
    }

    public String toString() {
        return "PDFOperator{" + this.theOperator + "}";
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public void setImageData(byte[] imageData) {
        this.imageData = imageData;
    }

    public COSDictionary getImageParameters() {
        return this.imageParameters;
    }

    public void setImageParameters(COSDictionary imageParams) {
        this.imageParameters = imageParams;
    }
}

