/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.font;

import java.awt.Graphics;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Category;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.pdmodel.font.PDFont;

public abstract class PDCIDFont
extends PDFont {
    private static Category log = Category.getInstance((String)(class$org$pdfbox$pdmodel$font$PDCIDFont == null ? (class$org$pdfbox$pdmodel$font$PDCIDFont = PDCIDFont.class$("org.pdfbox.pdmodel.font.PDCIDFont")) : class$org$pdfbox$pdmodel$font$PDCIDFont).getName());
    private Map widthCache = new HashMap();
    static /* synthetic */ Class class$org$pdfbox$pdmodel$font$PDCIDFont;

    public PDCIDFont() {
    }

    public PDCIDFont(COSDictionary fontDictionary) {
        super(fontDictionary);
    }

    public void drawString(String string, Graphics g, float fontSize, float x, float y) {
        throw new RuntimeException("Not yet implemented");
    }

    public long getDefaultWidth() {
        long dw = 1000L;
        COSNumber number = (COSNumber)this.font.getDictionaryObject(COSName.getPDFName("DW"));
        if (number != null) {
            dw = number.intValue();
        }
        return dw;
    }

    public void setDefaultWidth(long dw) {
        this.font.setItem(COSName.getPDFName("DW"), new COSInteger(dw));
    }

    public float getFontWidth(byte[] c, int offset, int length) throws IOException {
        float retval = 0.0f;
        int code = this.getCodeFromArray(c, offset, length);
        Float widthFloat = (Float)this.widthCache.get(new Integer(code));
        if (widthFloat == null) {
            float width = this.getDefaultWidth();
            COSArray widths = (COSArray)this.font.getDictionaryObject(COSName.getPDFName("W"));
            if (widths != null) {
                boolean foundWidth = false;
                this.widthCache = new HashMap();
                int i = 0;
                while (!foundWidth && i < widths.size()) {
                    COSNumber rangeWidth;
                    COSNumber firstCode = (COSNumber)widths.getObject(i++);
                    COSBase next = widths.getObject(i);
                    if (next instanceof COSArray) {
                        COSArray array = (COSArray)next;
                        if (code >= firstCode.intValue() && code < firstCode.intValue() + array.size()) {
                            rangeWidth = (COSNumber)array.get(code - firstCode.intValue());
                            retval = rangeWidth.floatValue();
                            foundWidth = true;
                        }
                    } else {
                        COSNumber secondCode = (COSNumber)next;
                        rangeWidth = (COSNumber)widths.getObject(++i);
                        if (code >= firstCode.intValue() && code <= secondCode.intValue()) {
                            retval = rangeWidth.floatValue();
                            foundWidth = true;
                        }
                    }
                    ++i;
                }
                this.widthCache.put(new Integer(code), new Float(retval));
            }
        } else {
            retval = widthFloat.floatValue();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("PDCIDFontType0Font.getFontWidth( code=" + code + " ) retval=" + retval));
        }
        return retval;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

