/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.common.COSDictionaryMap;
import org.pdfbox.pdmodel.font.PDFont;
import org.pdfbox.pdmodel.font.PDFontFactory;
import org.pdfbox.pdmodel.graphics.PDExtendedGraphicsState;

public class PDResources {
    private COSDictionary resources;

    public PDResources() {
        this.resources = new COSDictionary();
    }

    public PDResources(COSDictionary resourceDictionary) {
        this.resources = resourceDictionary;
    }

    public COSDictionary getCOSDictionary() {
        return this.resources;
    }

    public Map getFonts() throws IOException {
        COSDictionaryMap retval = null;
        COSDictionary fonts = (COSDictionary)this.resources.getDictionaryObject(COSName.FONT);
        if (fonts != null) {
            HashMap<String, PDFont> actuals = new HashMap<String, PDFont>();
            retval = new COSDictionaryMap(actuals, fonts);
            Iterator fontNames = fonts.keyList().iterator();
            while (fontNames.hasNext()) {
                COSName fontName = (COSName)fontNames.next();
                COSDictionary fontDictionary = (COSDictionary)fonts.getDictionaryObject(fontName);
                actuals.put(fontName.getName(), PDFontFactory.createFont(fontDictionary));
            }
        }
        return retval;
    }

    public void setFonts(Map fonts) {
        this.resources.setItem(COSName.FONT, COSDictionaryMap.convert(fonts));
    }

    public Map getGraphicsStates() {
        COSDictionaryMap retval = null;
        COSDictionary states = (COSDictionary)this.resources.getDictionaryObject(COSName.getPDFName("ExtGState"));
        if (states != null) {
            HashMap<String, PDExtendedGraphicsState> actuals = new HashMap<String, PDExtendedGraphicsState>();
            retval = new COSDictionaryMap(actuals, states);
            Iterator names = states.keyList().iterator();
            while (names.hasNext()) {
                COSName name = (COSName)names.next();
                COSDictionary dictionary = (COSDictionary)states.getDictionaryObject(name);
                actuals.put(name.getName(), new PDExtendedGraphicsState(dictionary));
            }
        }
        return retval;
    }

    public void setGraphicsStates(Map states) {
        Iterator iter = states.keySet().iterator();
        COSDictionary dic = new COSDictionary();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            PDExtendedGraphicsState state = (PDExtendedGraphicsState)states.get(name);
            dic.setItem(COSName.getPDFName(name), state.getCOSObject());
        }
        this.resources.setItem(COSName.getPDFName("ExtGState"), dic);
    }
}

