/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdfviewer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Category;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.common.PDRectangle;
import org.pdfbox.pdmodel.font.PDFont;
import org.pdfbox.util.PDFOperator;
import org.pdfbox.util.PDFStreamEngine;
import org.pdfbox.util.TextPosition;

public class PageDrawer
extends PDFStreamEngine {
    private static Category log = Category.getInstance((String)(class$org$pdfbox$util$PDFStreamEngine == null ? (class$org$pdfbox$util$PDFStreamEngine = PageDrawer.class$("org.pdfbox.util.PDFStreamEngine")) : class$org$pdfbox$util$PDFStreamEngine).getName());
    private Graphics2D graphics;
    private PDRectangle pageSize;
    private PDPage page;
    private GeneralPath linePath = new GeneralPath();
    static /* synthetic */ Class class$org$pdfbox$util$PDFStreamEngine;

    public void drawPage(Graphics g, PDPage p) throws IOException {
        this.graphics = (Graphics2D)g;
        this.page = p;
        this.pageSize = this.page.findMediaBox();
        this.processStream(p.getContents(), this.page.findResources().getFonts());
    }

    protected void showCharacter(TextPosition text) {
        try {
            this.graphics.setColor(Color.black);
            PDFont font = text.getFont();
            font.drawString(text.getString(), this.graphics, text.getFontSize(), text.getX(), this.pageSize.getHeight() - text.getY());
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    protected void processOperator(PDFOperator operator, List arguments) throws IOException {
        super.processOperator(operator, arguments);
        String operation = operator.getOperation();
        if (log.isDebugEnabled()) {
            log.debug((Object)("processOperator( '" + operation + "' )"));
        }
        if (operation.equals("l")) {
            COSNumber x = (COSNumber)arguments.get(0);
            COSNumber y = (COSNumber)arguments.get(1);
            this.linePath.lineTo(x.floatValue(), this.pageSize.getHeight() - y.floatValue());
        } else if (operation.equals("m")) {
            COSNumber x = (COSNumber)arguments.get(0);
            COSNumber y = (COSNumber)arguments.get(1);
            this.linePath.reset();
            this.linePath.moveTo(x.floatValue(), this.pageSize.getHeight() - y.floatValue());
        } else if (operation.equals("re")) {
            COSNumber x = (COSNumber)arguments.get(0);
            COSNumber y = (COSNumber)arguments.get(1);
            COSNumber w = (COSNumber)arguments.get(2);
            COSNumber h = (COSNumber)arguments.get(3);
            Rectangle2D.Double rect = new Rectangle2D.Double(x.doubleValue(), (double)this.pageSize.getHeight() - y.doubleValue(), w.doubleValue(), h.doubleValue());
            this.linePath.reset();
            this.linePath.append(rect, false);
        } else if (operation.equals("S")) {
            this.graphics.draw(this.linePath);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

