/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.cos;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.ICOSVisitor;
import org.pdfbox.exceptions.COSVisitorException;

public class COSString
extends COSBase {
    private ByteArrayOutputStream out = new ByteArrayOutputStream();

    public COSString() {
    }

    public COSString(String value) {
        try {
            this.out.write(value.getBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getString() {
        String retval;
        String encoding = null;
        byte[] data = this.getBytes();
        int start = 0;
        if (data.length > 2) {
            if (data[0] == -1 && data[1] == -2) {
                encoding = "UTF-16LE";
                start = 2;
            } else if (data[0] == -2 && data[1] == -1) {
                encoding = "UTF-16BE";
                start = 2;
            }
        }
        try {
            retval = encoding != null ? new String(this.getBytes(), start, data.length - start, encoding) : new String(this.getBytes());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            retval = new String(this.getBytes());
        }
        return retval;
    }

    public void append(byte[] data) throws IOException {
        this.out.write(data);
    }

    public void append(int in) throws IOException {
        this.out.write(in);
    }

    public void reset() {
        this.out.reset();
    }

    public byte[] getBytes() {
        return this.out.toByteArray();
    }

    public String toString() {
        return "COSString{" + new String(this.getBytes()) + "}";
    }

    public Object accept(ICOSVisitor visitor) throws COSVisitorException {
        return visitor.visitFromString(this);
    }

    public boolean equals(Object obj) {
        return obj instanceof COSString && Arrays.equals(((COSString)obj).getBytes(), this.getBytes());
    }

    public int hashCode() {
        return this.getBytes().hashCode();
    }
}

