/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.cos;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.cos.COSObject;
import org.pdfbox.cos.ICOSVisitor;
import org.pdfbox.exceptions.COSVisitorException;

public class COSArray
extends COSBase {
    private List objects = new ArrayList();

    public void add(COSBase object) {
        this.objects.add(object);
    }

    public void add(int i, COSBase object) {
        this.objects.add(i, object);
    }

    public void clear() {
        this.objects.clear();
    }

    public void removeAll(Collection objects) {
        this.objects.removeAll(objects);
    }

    public void retainAll(Collection objects) {
        this.objects.retainAll(objects);
    }

    public void addAll(Collection objects) {
        this.objects.addAll(objects);
    }

    public void addAll(COSArray objectList) {
        this.objects.addAll(objectList.objects);
    }

    public void addAll(int i, Collection objectList) {
        this.objects.addAll(i, objectList);
    }

    public void set(int index, COSBase object) {
        this.objects.set(index, object);
    }

    public COSBase getObject(int index) {
        Object obj = this.objects.get(index);
        if (obj instanceof COSObject) {
            obj = ((COSObject)obj).getObject();
        }
        return (COSBase)obj;
    }

    public COSBase get(int index) {
        return (COSBase)this.objects.get(index);
    }

    public int size() {
        return this.objects.size();
    }

    public COSBase remove(int i) {
        return (COSBase)this.objects.remove(i);
    }

    public boolean remove(COSBase o) {
        return this.objects.remove(o);
    }

    public String toString() {
        return "COSArray{" + this.objects + "}";
    }

    public Iterator iterator() {
        return this.objects.iterator();
    }

    public int indexOf(COSBase object) {
        int retval = -1;
        int i = 0;
        while (retval < 0 && i < this.size()) {
            if (this.get(i).equals(object)) {
                retval = i;
            }
            ++i;
        }
        return retval;
    }

    public Object accept(ICOSVisitor visitor) throws COSVisitorException {
        return visitor.visitFromArray(this);
    }

    protected void addTo(COSDocument doc) {
        super.addTo(doc);
        Iterator i = this.iterator();
        while (i.hasNext()) {
            COSBase contained = (COSBase)i.next();
            contained.addTo(doc);
        }
    }
}

