/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.util.Hashtable;
import sun.tools.java.Constants;
import sun.tools.java.Type;

public final class Identifier
implements Constants {
    static Hashtable hash = new Hashtable(3001, 0.5f);
    String name;
    Object value;
    Type typeObject = null;
    private int ipos;
    public static final char INNERCLASS_PREFIX = ' ';
    private static final String ambigPrefix = "<<ambiguous>>";

    private Identifier(String string) {
        this.name = string;
        this.ipos = string.indexOf(32);
    }

    int getType() {
        return this.value != null && this.value instanceof Integer ? (Integer)this.value : 60;
    }

    void setType(int n) {
        this.value = new Integer(n);
    }

    public static synchronized Identifier lookup(String string) {
        Identifier identifier = (Identifier)hash.get(string);
        if (identifier == null) {
            identifier = new Identifier(string);
            hash.put(string, identifier);
        }
        return identifier;
    }

    public static Identifier lookup(Identifier identifier, Identifier identifier2) {
        if (identifier == Constants.idNull) {
            return identifier2;
        }
        if (identifier.name.charAt(identifier.name.length() - 1) == ' ') {
            return Identifier.lookup(identifier.name + identifier2.name);
        }
        Identifier identifier3 = Identifier.lookup(identifier + "." + identifier2);
        if (!identifier2.isQualified() && !identifier.isInner()) {
            identifier3.value = identifier;
        }
        return identifier3;
    }

    public static Identifier lookupInner(Identifier identifier, Identifier identifier2) {
        Identifier identifier3 = identifier.isInner() ? (identifier.name.charAt(identifier.name.length() - 1) == ' ' ? Identifier.lookup(identifier.name + identifier2) : Identifier.lookup(identifier, identifier2)) : Identifier.lookup(identifier + "." + ' ' + identifier2);
        identifier3.value = identifier.value;
        return identifier3;
    }

    public String toString() {
        return this.name;
    }

    public boolean isQualified() {
        if (this.value == null) {
            int n = this.ipos;
            n = n <= 0 ? this.name.length() : --n;
            int n2 = this.name.lastIndexOf(46, n - 1);
            this.value = n2 < 0 ? Constants.idNull : Identifier.lookup(this.name.substring(0, n2));
        }
        return this.value instanceof Identifier && this.value != Constants.idNull;
    }

    public Identifier getQualifier() {
        return this.isQualified() ? (Identifier)this.value : Constants.idNull;
    }

    public Identifier getName() {
        return this.isQualified() ? Identifier.lookup(this.name.substring(((Identifier)this.value).name.length() + 1)) : this;
    }

    public boolean isInner() {
        return this.ipos > 0;
    }

    public Identifier getFlatName() {
        if (this.isQualified()) {
            return this.getName().getFlatName();
        }
        if (this.ipos > 0 && this.name.charAt(this.ipos - 1) == '.') {
            if (this.ipos + 1 == this.name.length()) {
                return Identifier.lookup(this.name.substring(0, this.ipos - 1));
            }
            String string = this.name.substring(this.ipos + 1);
            String string2 = this.name.substring(0, this.ipos);
            return Identifier.lookup(string2 + string);
        }
        return this;
    }

    public Identifier getTopName() {
        if (!this.isInner()) {
            return this;
        }
        return Identifier.lookup(this.getQualifier(), this.getFlatName().getHead());
    }

    public Identifier getHead() {
        Identifier identifier = this;
        while (identifier.isQualified()) {
            identifier = identifier.getQualifier();
        }
        return identifier;
    }

    public Identifier getTail() {
        Identifier identifier = this.getHead();
        if (identifier == this) {
            return Constants.idNull;
        }
        return Identifier.lookup(this.name.substring(identifier.name.length() + 1));
    }

    public boolean hasAmbigPrefix() {
        return this.name.startsWith(ambigPrefix);
    }

    public Identifier addAmbigPrefix() {
        return Identifier.lookup(ambigPrefix + this.name);
    }

    public Identifier removeAmbigPrefix() {
        if (this.hasAmbigPrefix()) {
            return Identifier.lookup(this.name.substring(ambigPrefix.length()));
        }
        return this;
    }
}

