/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentTermEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.store.Directory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
final class TermInfosReader {
    private Directory directory;
    private String segment;
    private FieldInfos fieldInfos;
    private SegmentTermEnum enum;
    private int size;
    Term[] indexTerms = null;
    TermInfo[] indexInfos;
    long[] indexPointers;

    TermInfosReader(Directory directory, String string, FieldInfos fieldInfos) throws IOException {
        this.directory = directory;
        this.segment = string;
        this.fieldInfos = fieldInfos;
        this.enum = new SegmentTermEnum(this.directory.openFile(this.segment + ".tis"), this.fieldInfos, false);
        this.size = this.enum.size;
        this.readIndex();
    }

    final void close() throws IOException {
        if (this.enum != null) {
            this.enum.close();
        }
    }

    final int size() {
        return this.size;
    }

    private final void readIndex() throws IOException {
        SegmentTermEnum segmentTermEnum = new SegmentTermEnum(this.directory.openFile(this.segment + ".tii"), this.fieldInfos, true);
        try {
            int n = segmentTermEnum.size;
            this.indexTerms = new Term[n];
            this.indexInfos = new TermInfo[n];
            this.indexPointers = new long[n];
            int n2 = 0;
            while (segmentTermEnum.next()) {
                this.indexTerms[n2] = segmentTermEnum.term();
                this.indexInfos[n2] = segmentTermEnum.termInfo();
                this.indexPointers[n2] = segmentTermEnum.indexPointer;
                ++n2;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            segmentTermEnum.close();
            throw throwable;
        }
        segmentTermEnum.close();
    }

    private final int getIndexOffset(Term term) throws IOException {
        int n = 0;
        int n2 = this.indexTerms.length - 1;
        while (n2 >= n) {
            int n3 = n + n2 >> 1;
            int n4 = term.compareTo(this.indexTerms[n3]);
            if (n4 < 0) {
                n2 = n3 - 1;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            return n3;
        }
        return n2;
    }

    private final void seekEnum(int n) throws IOException {
        this.enum.seek(this.indexPointers[n], n * 128 - 1, this.indexTerms[n], this.indexInfos[n]);
    }

    final synchronized TermInfo get(Term term) throws IOException {
        int n;
        if (this.size == 0) {
            return null;
        }
        if (this.enum.term() != null && (this.enum.prev != null && term.compareTo(this.enum.prev) > 0 || term.compareTo(this.enum.term()) >= 0) && (this.indexTerms.length == (n = this.enum.position / 128 + 1) || term.compareTo(this.indexTerms[n]) < 0)) {
            return this.scanEnum(term);
        }
        this.seekEnum(this.getIndexOffset(term));
        return this.scanEnum(term);
    }

    private final TermInfo scanEnum(Term term) throws IOException {
        while (term.compareTo(this.enum.term()) > 0 && this.enum.next()) {
        }
        if (this.enum.term() != null && term.compareTo(this.enum.term()) == 0) {
            return this.enum.termInfo();
        }
        return null;
    }

    final synchronized Term get(int n) throws IOException {
        if (this.size == 0) {
            return null;
        }
        if (this.enum != null && this.enum.term() != null && n >= this.enum.position && n < this.enum.position + 128) {
            return this.scanEnum(n);
        }
        this.seekEnum(n / 128);
        return this.scanEnum(n);
    }

    private final Term scanEnum(int n) throws IOException {
        while (this.enum.position < n) {
            if (this.enum.next()) continue;
            return null;
        }
        return this.enum.term();
    }

    final synchronized int getPosition(Term term) throws IOException {
        if (this.size == 0) {
            return -1;
        }
        int n = this.getIndexOffset(term);
        this.seekEnum(n);
        while (term.compareTo(this.enum.term()) > 0 && this.enum.next()) {
        }
        if (term.compareTo(this.enum.term()) == 0) {
            return this.enum.position;
        }
        return -1;
    }

    final synchronized SegmentTermEnum terms() throws IOException {
        if (this.enum.position != -1) {
            this.seekEnum(0);
        }
        return (SegmentTermEnum)this.enum.clone();
    }

    final synchronized SegmentTermEnum terms(Term term) throws IOException {
        this.get(term);
        return (SegmentTermEnum)this.enum.clone();
    }
}

