/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.compilers;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.compilers.DefaultCompilerAdapter;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;

public class Jikes
extends DefaultCompilerAdapter {
    public boolean execute() throws BuildException {
        String fullDependProperty;
        String pedanticProperty;
        String warningsProperty;
        String emacsProperty;
        this.attributes.log("Using jikes compiler", 3);
        Path classpath = new Path(this.project);
        if (this.bootclasspath != null) {
            classpath.append(this.bootclasspath);
        }
        classpath.addExtdirs(this.extdirs);
        if (this.bootclasspath == null || this.bootclasspath.size() == 0) {
            this.includeJavaRuntime = true;
        }
        classpath.append(this.getCompileClasspath());
        if (this.compileSourcepath != null) {
            classpath.append(this.compileSourcepath);
        } else {
            classpath.append(this.src);
        }
        String jikesPath = System.getProperty("jikes.class.path");
        if (jikesPath != null) {
            classpath.append(new Path(this.project, jikesPath));
        }
        Commandline cmd = new Commandline();
        cmd.setExecutable("jikes");
        if (this.deprecation) {
            cmd.createArgument().setValue("-deprecation");
        }
        if (this.destDir != null) {
            cmd.createArgument().setValue("-d");
            cmd.createArgument().setFile(this.destDir);
        }
        cmd.createArgument().setValue("-classpath");
        cmd.createArgument().setPath(classpath);
        if (this.encoding != null) {
            cmd.createArgument().setValue("-encoding");
            cmd.createArgument().setValue(this.encoding);
        }
        if (this.debug) {
            cmd.createArgument().setValue("-g");
        }
        if (this.optimize) {
            cmd.createArgument().setValue("-O");
        }
        if (this.verbose) {
            cmd.createArgument().setValue("-verbose");
        }
        if (this.depend) {
            cmd.createArgument().setValue("-depend");
        }
        if ((emacsProperty = this.project.getProperty("build.compiler.emacs")) != null && Project.toBoolean(emacsProperty)) {
            cmd.createArgument().setValue("+E");
        }
        if ((warningsProperty = this.project.getProperty("build.compiler.warnings")) != null) {
            this.attributes.log("!! the build.compiler.warnings property is deprecated. !!", 1);
            this.attributes.log("!! Use the nowarn attribute instead. !!", 1);
            if (!Project.toBoolean(warningsProperty)) {
                cmd.createArgument().setValue("-nowarn");
            }
        }
        if (this.attributes.getNowarn()) {
            cmd.createArgument().setValue("-nowarn");
        }
        if ((pedanticProperty = this.project.getProperty("build.compiler.pedantic")) != null && Project.toBoolean(pedanticProperty)) {
            cmd.createArgument().setValue("+P");
        }
        if ((fullDependProperty = this.project.getProperty("build.compiler.fulldepend")) != null && Project.toBoolean(fullDependProperty)) {
            cmd.createArgument().setValue("+F");
        }
        if (this.attributes.getSource() != null) {
            cmd.createArgument().setValue("-source");
            cmd.createArgument().setValue(this.attributes.getSource());
        }
        this.addCurrentCompilerArgs(cmd);
        int firstFileName = cmd.size();
        this.logAndAddFilesToCompile(cmd);
        return this.executeExternalCompile(cmd.getCommandline(), firstFileName) == 0;
    }
}

