/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.graphics;

import java.io.IOException;
import java.util.Iterator;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSBoolean;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSFloat;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.graphics.PDFontSetting;
import org.pdfbox.pdmodel.graphics.PDGraphicsState;
import org.pdfbox.pdmodel.graphics.PDLineDashPattern;

public class PDExtendedGraphicsState
implements COSObjectable {
    private static final COSName LW = COSName.getPDFName("LW");
    private static final COSName LC = COSName.getPDFName("LC");
    private static final COSName LJ = COSName.getPDFName("LJ");
    private static final COSName ML = COSName.getPDFName("ML");
    private static final COSName D = COSName.getPDFName("D");
    private static final COSName RI = COSName.getPDFName("RI");
    private static final COSName OP = COSName.getPDFName("OP");
    private static final COSName OP_NS = COSName.getPDFName("op");
    private static final COSName OPM = COSName.getPDFName("OPM");
    private static final COSName FONT = COSName.getPDFName("Font");
    private static final COSName FL = COSName.getPDFName("FL");
    private static final COSName SM = COSName.getPDFName("SM");
    private static final COSName SA = COSName.getPDFName("SA");
    private static final COSName CA = COSName.getPDFName("CA");
    private static final COSName CA_NS = COSName.getPDFName("ca");
    private static final COSName AIS = COSName.getPDFName("AIS");
    private static final COSName TK = COSName.getPDFName("TK");
    public static final String RENDERING_INTENT_ABSOLUTE_COLORIMETRIC = "AbsoluteColorimetric";
    public static final String RENDERING_INTENT_RELATIVE_COLORIMETRIC = "RelativeColorimetric";
    public static final String RENDERING_INTENT_SATURATION = "Saturation";
    public static final String RENDERING_INTENT_PERCEPTUAL = "Perceptual";
    private COSDictionary graphicsState;

    public PDExtendedGraphicsState() {
        this.graphicsState = new COSDictionary();
        this.graphicsState.setItem(COSName.TYPE, COSName.getPDFName("ExtGState"));
    }

    public PDExtendedGraphicsState(COSDictionary dictionary) {
        this.graphicsState = dictionary;
    }

    public void copyIntoGraphicsState(PDGraphicsState gs) throws IOException {
        Iterator keys = this.graphicsState.keyList().iterator();
        while (keys.hasNext()) {
            COSName key = (COSName)keys.next();
            if (key.equals(LW)) {
                gs.setLineWidth(this.getLineWidth().doubleValue());
                continue;
            }
            if (key.equals(LC)) {
                gs.setLineCap(this.getLineCapStyle().intValue());
                continue;
            }
            if (key.equals(LJ)) {
                gs.setLineJoin(this.getLineJoinStyle().intValue());
                continue;
            }
            if (key.equals(ML)) {
                gs.setMiterLimit(this.getMiterLimit().doubleValue());
                continue;
            }
            if (key.equals(D)) {
                gs.setLineDashPattern(this.getLineDashPattern());
                continue;
            }
            if (key.equals(RI)) {
                gs.setRenderingIntent(this.getRenderingIntent());
                continue;
            }
            if (key.equals(OPM)) {
                gs.setOverprintMode(this.getOverprintMode().doubleValue());
                continue;
            }
            if (key.equals(FONT)) {
                PDFontSetting setting = this.getFontSetting();
                gs.getTextState().setFont(setting.getFont());
                gs.getTextState().setFontSize(setting.getFontSize());
                continue;
            }
            if (key.equals(FL)) {
                gs.setFlatness(this.getFlatnessTolerance().floatValue());
                continue;
            }
            if (key.equals(SM)) {
                gs.setSmoothness(this.getSmoothnessTolerance().floatValue());
                continue;
            }
            if (key.equals(SA)) {
                gs.setStrokeAdjustment(this.getAutomaticStrokeAdjustment());
                continue;
            }
            if (key.equals(CA)) {
                gs.setAlphaConstants(this.getStrokingAlpaConstant().floatValue());
                continue;
            }
            if (key.equals(AIS)) {
                gs.setAlphaSource(this.getAlpaSourceFlag());
                continue;
            }
            if (!key.equals(TK)) continue;
            gs.getTextState().setKnockoutFlag(this.getTextKnockoutFlag());
        }
    }

    public COSDictionary getCOSDictionary() {
        return this.graphicsState;
    }

    public COSBase getCOSObject() {
        return this.graphicsState;
    }

    public Float getLineWidth() {
        return this.getFloatItem(LW);
    }

    public void setLineWidth(Float width) {
        this.setFloatItem(LW, width);
    }

    public Long getLineCapStyle() {
        return this.getLongItem(LC);
    }

    public void setLineCapStyle(Long style) {
        this.setLongItem(LC, style);
    }

    public Long getLineJoinStyle() {
        return this.getLongItem(LJ);
    }

    public void setLineJoinStyle(Long style) {
        this.setLongItem(LJ, style);
    }

    public Float getMiterLimit() {
        return this.getFloatItem(ML);
    }

    public void setMiterLimit(Float miterLimit) {
        this.setFloatItem(ML, miterLimit);
    }

    public PDLineDashPattern getLineDashPattern() {
        PDLineDashPattern retval = null;
        COSArray dp = (COSArray)this.graphicsState.getDictionaryObject(D);
        if (dp != null) {
            retval = new PDLineDashPattern(dp);
        }
        return retval;
    }

    public void setLineDashPattern(PDLineDashPattern dashPattern) {
        this.graphicsState.setItem(D, dashPattern.getCOSObject());
    }

    public String getRenderingIntent() {
        String retval = null;
        COSName ri = (COSName)this.graphicsState.getDictionaryObject(RI);
        if (ri != null) {
            retval = ri.getName();
        }
        return retval;
    }

    public void setRenderingIntent(String ri) {
        COSName intent = null;
        if (ri != null) {
            intent = COSName.getPDFName(ri);
        }
        this.graphicsState.setItem(RI, intent);
    }

    public Boolean getStrokingOverprintControl() {
        return this.getBooleanItem(OP);
    }

    public void setStrokingOverprintControl(Boolean op) {
        this.setBooleanItem(OP, op);
    }

    public Boolean getNonStrokingOverprintControl() {
        Boolean retval = this.getBooleanItem(OP_NS);
        if (retval == null) {
            retval = this.getStrokingOverprintControl();
        }
        return retval;
    }

    public void setNonStrokingOverprintControl(Boolean op) {
        this.setBooleanItem(OP_NS, op);
    }

    public Float getOverprintMode() {
        return this.getFloatItem(OPM);
    }

    public void setOverprintMode(Float overprintMode) {
        this.setFloatItem(OPM, overprintMode);
    }

    public PDFontSetting getFontSetting() {
        PDFontSetting setting = null;
        COSArray font = (COSArray)this.graphicsState.getDictionaryObject(FONT);
        if (font != null) {
            setting = new PDFontSetting(font);
        }
        return setting;
    }

    public void setFontSetting(PDFontSetting fs) {
        if (fs == null) {
            this.graphicsState.setItem(FONT, null);
        } else {
            this.graphicsState.setItem(FONT, fs.getCOSObject());
        }
    }

    public Float getFlatnessTolerance() {
        return this.getFloatItem(FL);
    }

    public void setFlatnessTolerance(Float flatness) {
        this.setFloatItem(FL, flatness);
    }

    public Float getSmoothnessTolerance() {
        return this.getFloatItem(SM);
    }

    public void setSmoothnessTolerance(Float smoothness) {
        this.setFloatItem(SM, smoothness);
    }

    public Boolean getAutomaticStrokeAdjustment() {
        return this.getBooleanItem(SA);
    }

    public void setAutomaticStrokeAdjustment(Boolean sa) {
        this.setBooleanItem(SA, sa);
    }

    public Float getStrokingAlpaConstant() {
        return this.getFloatItem(CA);
    }

    public void setStrokingAlphaConstant(Float alpha) {
        this.setFloatItem(CA, alpha);
    }

    public Float getNonStrokingAlpaConstant() {
        return this.getFloatItem(CA_NS);
    }

    public void setNonStrokingAlphaConstant(Float alpha) {
        this.setFloatItem(CA_NS, alpha);
    }

    public Boolean getAlpaSourceFlag() {
        return this.getBooleanItem(AIS);
    }

    public void setAlphaSourceFlag(Boolean alpha) {
        this.setBooleanItem(AIS, alpha);
    }

    public Boolean getTextKnockoutFlag() {
        return this.getBooleanItem(TK);
    }

    public void setTextKnockoutFlag(Boolean tk) {
        this.setBooleanItem(TK, tk);
    }

    private Float getFloatItem(COSName key) {
        Float retval = null;
        COSNumber value = (COSNumber)this.graphicsState.getDictionaryObject(key);
        if (value != null) {
            retval = new Float(value.floatValue());
        }
        return retval;
    }

    private void setFloatItem(COSName key, Float value) {
        if (value == null) {
            this.graphicsState.removeItem(key);
        } else {
            this.graphicsState.setItem(key, new COSFloat(value.floatValue()));
        }
    }

    private Integer getIntegerItem(COSName key) {
        Integer retval = null;
        COSNumber value = (COSNumber)this.graphicsState.getDictionaryObject(key);
        if (value != null) {
            retval = new Integer(value.intValue());
        }
        return retval;
    }

    private void setIntegerItem(COSName key, Integer value) {
        if (value == null) {
            this.graphicsState.removeItem(key);
        } else {
            this.graphicsState.setItem(key, new COSInteger(value));
        }
    }

    private Long getLongItem(COSName key) {
        Long retval = null;
        COSNumber value = (COSNumber)this.graphicsState.getDictionaryObject(key);
        if (value != null) {
            retval = new Long(value.intValue());
        }
        return retval;
    }

    private void setLongItem(COSName key, Long value) {
        if (value == null) {
            this.graphicsState.removeItem(key);
        } else {
            this.graphicsState.setItem(key, new COSInteger(value));
        }
    }

    private Boolean getBooleanItem(COSName key) {
        Boolean retval = null;
        COSBoolean value = (COSBoolean)this.graphicsState.getDictionaryObject(key);
        if (value != null) {
            retval = value.getValueAsObject();
        }
        return retval;
    }

    private void setBooleanItem(COSName key, Boolean value) {
        if (value == null) {
            this.graphicsState.removeItem(key);
        } else {
            this.graphicsState.setItem(key, COSBoolean.getBoolean(value));
        }
    }
}

