/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import sun.tools.asm.Assembler;
import sun.tools.asm.Label;
import sun.tools.asm.SwitchData;
import sun.tools.java.Environment;
import sun.tools.java.Type;
import sun.tools.tree.CaseStatement;
import sun.tools.tree.CheckContext;
import sun.tools.tree.CodeContext;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;
import sun.tools.tree.IntegerExpression;
import sun.tools.tree.Node;
import sun.tools.tree.Statement;
import sun.tools.tree.Vset;

public class SwitchStatement
extends Statement {
    Expression expr;
    Statement[] args;

    public SwitchStatement(long l, Expression expression, Statement[] statementArray) {
        super(95, l);
        this.expr = expression;
        this.args = statementArray;
    }

    Vset check(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        this.checkLabel(environment, context);
        CheckContext checkContext = new CheckContext(context, this);
        vset = this.expr.checkValue(environment, checkContext, this.reach(environment, vset), hashtable);
        Type type = this.expr.type;
        this.expr = this.convert(environment, checkContext, Type.tInt, this.expr);
        Hashtable<Expression, Statement> hashtable2 = new Hashtable<Expression, Statement>();
        boolean bl = false;
        Vset vset2 = Statement.DEAD_END;
        int n = 0;
        while (n < this.args.length) {
            Statement statement = this.args[n];
            if (statement.op == 96) {
                vset2 = statement.check(environment, checkContext, vset2.join(vset.copy()), hashtable);
                Expression expression = ((CaseStatement)statement).expr;
                if (expression != null) {
                    if (expression instanceof IntegerExpression) {
                        Integer n2 = (Integer)((IntegerExpression)expression).getValue();
                        int n3 = n2;
                        if (hashtable2.get(expression) != null) {
                            environment.error(statement.where, "duplicate.label", n2);
                        } else {
                            boolean bl2;
                            hashtable2.put(expression, statement);
                            switch (type.getTypeCode()) {
                                case 1: {
                                    bl2 = n3 != (byte)n3;
                                    break;
                                }
                                case 3: {
                                    bl2 = n3 != (short)n3;
                                    break;
                                }
                                case 2: {
                                    bl2 = n3 != (char)n3;
                                    break;
                                }
                                default: {
                                    bl2 = false;
                                }
                            }
                            if (bl2) {
                                environment.error(statement.where, "switch.overflow", n2, type);
                            }
                        }
                    } else if (!expression.isConstant() || expression.getType() != Type.tInt) {
                        environment.error(statement.where, "const.expr.required");
                    }
                } else {
                    if (bl) {
                        environment.error(statement.where, "duplicate.default");
                    }
                    bl = true;
                }
            } else {
                vset2 = statement.checkBlockStatement(environment, checkContext, vset2, hashtable);
            }
            ++n;
        }
        if (!vset2.isDeadEnd()) {
            checkContext.vsBreak = checkContext.vsBreak.join(vset2);
        }
        if (bl) {
            vset = checkContext.vsBreak;
        }
        return context.removeAdditionalVars(vset);
    }

    public Statement inline(Environment environment, Context context) {
        context = new Context(context, this);
        this.expr = this.expr.inlineValue(environment, context);
        int n = 0;
        while (n < this.args.length) {
            if (this.args[n] != null) {
                this.args[n] = this.args[n].inline(environment, context);
            }
            ++n;
        }
        return this;
    }

    public Statement copyInline(Context context, boolean bl) {
        SwitchStatement switchStatement = (SwitchStatement)this.clone();
        switchStatement.expr = this.expr.copyInline(context);
        switchStatement.args = new Statement[this.args.length];
        int n = 0;
        while (n < this.args.length) {
            if (this.args[n] != null) {
                switchStatement.args[n] = this.args[n].copyInline(context, bl);
            }
            ++n;
        }
        return switchStatement;
    }

    public int costInline(int n, Environment environment, Context context) {
        int n2 = this.expr.costInline(n, environment, context);
        int n3 = 0;
        while (n3 < this.args.length && n2 < n) {
            if (this.args[n3] != null) {
                n2 += this.args[n3].costInline(n, environment, context);
            }
            ++n3;
        }
        return n2;
    }

    public void code(Environment environment, Context context, Assembler assembler) {
        Node node;
        CodeContext codeContext = new CodeContext(context, this);
        this.expr.codeValue(environment, codeContext, assembler);
        SwitchData switchData = new SwitchData();
        boolean bl = false;
        int n = 0;
        while (n < this.args.length) {
            Statement statement = this.args[n];
            if (statement != null && statement.op == 96) {
                node = ((CaseStatement)statement).expr;
                if (node != null) {
                    switchData.add(((IntegerExpression)node).value, new Label());
                } else {
                    bl = true;
                }
            }
            ++n;
        }
        if (environment.coverage()) {
            switchData.initTableCase();
        }
        assembler.add(this.where, 170, switchData);
        int n2 = 0;
        while (n2 < this.args.length) {
            node = this.args[n2];
            if (node != null) {
                if (((Statement)node).op == 96) {
                    Expression expression = ((CaseStatement)node).expr;
                    if (expression != null) {
                        assembler.add(switchData.get(((IntegerExpression)expression).value));
                        switchData.addTableCase(((IntegerExpression)expression).value, ((Statement)node).where);
                    } else {
                        assembler.add(switchData.getDefaultLabel());
                        switchData.addTableDefault(((Statement)node).where);
                    }
                } else {
                    ((Statement)node).code(environment, codeContext, assembler);
                }
            }
            ++n2;
        }
        if (!bl) {
            assembler.add(switchData.getDefaultLabel());
        }
        assembler.add(codeContext.breakLabel);
    }

    public void print(PrintStream printStream, int n) {
        super.print(printStream, n);
        printStream.print("switch (");
        this.expr.print(printStream);
        printStream.print(") {\n");
        int n2 = 0;
        while (n2 < this.args.length) {
            if (this.args[n2] != null) {
                this.printIndent(printStream, n + 1);
                this.args[n2].print(printStream, n + 1);
                printStream.print("\n");
            }
            ++n2;
        }
        this.printIndent(printStream, n);
        printStream.print("}");
    }
}

