/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import sun.applet.AppletMessageHandler;
import sun.applet.AppletSecurity;
import sun.applet.AppletViewer;
import sun.net.www.ParseUtil;

public class Main {
    static File theUserPropertiesFile;
    static final String[][] avDefaultUserProps;
    private static AppletMessageHandler amh;
    private boolean debugFlag = false;
    private boolean helpFlag = false;
    private String encoding = null;
    private boolean noSecurityFlag = false;
    private static boolean cmdLineTestFlag;
    private static Vector urlList;
    public static final String theVersion;
    static /* synthetic */ Class array$Ljava$lang$String;

    public static void main(String[] stringArray) {
        Main main = new Main();
        int n = main.run(stringArray);
        if (n != 0 || cmdLineTestFlag) {
            System.exit(n);
        }
    }

    private int run(String[] stringArray) {
        int n;
        try {
            if (stringArray.length == 0) {
                Main.usage();
                return 0;
            }
            n = 0;
            while (n < stringArray.length) {
                int n2 = this.decodeArg(stringArray, n);
                if (n2 == 0) {
                    throw new ParseException(Main.lookup("main.err.unrecognizedarg", stringArray[n]));
                }
                n += n2;
            }
        }
        catch (ParseException parseException) {
            System.err.println(parseException.getMessage());
            return 1;
        }
        if (this.helpFlag) {
            Main.usage();
            return 0;
        }
        if (urlList.size() == 0) {
            System.err.println(Main.lookup("main.err.inputfile"));
            return 1;
        }
        if (this.debugFlag) {
            return this.invokeDebugger(stringArray);
        }
        if (!this.noSecurityFlag && System.getSecurityManager() == null) {
            this.init();
        }
        n = 0;
        while (n < urlList.size()) {
            try {
                AppletViewer.parse((URL)urlList.elementAt(n), this.encoding);
            }
            catch (IOException iOException) {
                System.err.println(Main.lookup("main.err.io", iOException.getMessage()));
                return 1;
            }
            ++n;
        }
        return 0;
    }

    private static void usage() {
        System.out.println(Main.lookup("usage"));
    }

    private int decodeArg(String[] stringArray, int n) throws ParseException {
        String string = stringArray[n];
        int n2 = stringArray.length;
        if ("-help".equalsIgnoreCase(string) || "-?".equals(string)) {
            this.helpFlag = true;
            return 1;
        }
        if ("-encoding".equals(string) && n < n2 - 1) {
            if (this.encoding != null) {
                throw new ParseException(Main.lookup("main.err.dupoption", string));
            }
            this.encoding = stringArray[++n];
            return 2;
        }
        if ("-debug".equals(string)) {
            this.debugFlag = true;
            return 1;
        }
        if ("-Xnosecurity".equals(string)) {
            System.err.println();
            System.err.println(Main.lookup("main.warn.nosecmgr"));
            System.err.println();
            this.noSecurityFlag = true;
            return 1;
        }
        if ("-XcmdLineTest".equals(string)) {
            cmdLineTestFlag = true;
            return 1;
        }
        if (string.startsWith("-")) {
            throw new ParseException(Main.lookup("main.err.unsupportedopt", string));
        }
        URL uRL = this.parseURL(string);
        if (uRL != null) {
            urlList.addElement(uRL);
            return 1;
        }
        return 0;
    }

    private URL parseURL(String string) throws ParseException {
        URL uRL = null;
        try {
            String string2;
            uRL = string.indexOf(58) <= 1 ? ParseUtil.fileToEncodedURL(new File(System.getProperty("user.dir"), string)) : (string.startsWith("file:") && string.replace(File.separatorChar, '/').indexOf(47) == -1 ? ((string2 = string.substring("file:".length())).length() > 0 ? ParseUtil.fileToEncodedURL(new File(System.getProperty("user.dir"), string2)) : new URL(string)) : new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            throw new ParseException(Main.lookup("main.err.badurl", string, malformedURLException.getMessage()));
        }
        return uRL;
    }

    private int invokeDebugger(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length + 1];
        int n = 0;
        String string = System.getProperty("java.home") + File.separator + "phony";
        stringArray2[n++] = "-Djava.class.path=" + string;
        stringArray2[n++] = "sun.applet.Main";
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (!"-debug".equals(stringArray[n2])) {
                stringArray2[n++] = stringArray[n2];
            }
            ++n2;
        }
        try {
            Class<?> clazz = Class.forName("com.sun.tools.example.debug.tty.TTY", true, ClassLoader.getSystemClassLoader());
            Method method = clazz.getDeclaredMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = Main.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            method.invoke(null, new Object[]{stringArray2});
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(Main.lookup("main.debug.cantfinddebug"));
            return 1;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println(Main.lookup("main.debug.cantfindmain"));
            return 1;
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println(Main.lookup("main.debug.exceptionindebug"));
            return 1;
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println(Main.lookup("main.debug.cantaccess"));
            return 1;
        }
        return 0;
    }

    private void init() {
        Properties properties = this.getAVProps();
        properties.put("browser", "sun.applet.AppletViewer");
        properties.put("browser.version", "1.06");
        properties.put("browser.vendor", "Sun Microsystems Inc.");
        properties.put("http.agent", "Java(tm) 2 SDK, Standard Edition v" + theVersion);
        properties.put("package.restrict.definition.java", "true");
        properties.put("package.restrict.definition.sun", "true");
        properties.put("java.version.applet", "true");
        properties.put("java.vendor.applet", "true");
        properties.put("java.vendor.url.applet", "true");
        properties.put("java.class.version.applet", "true");
        properties.put("os.name.applet", "true");
        properties.put("os.version.applet", "true");
        properties.put("os.arch.applet", "true");
        properties.put("file.separator.applet", "true");
        properties.put("path.separator.applet", "true");
        properties.put("line.separator.applet", "true");
        Properties properties2 = System.getProperties();
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)properties.setProperty(string2, string = properties2.getProperty(string2));
            if (string3 == null) continue;
            System.err.println(Main.lookup("main.warn.prop.overwrite", string2, string3, string));
        }
        System.setProperties(properties);
        if (!this.noSecurityFlag) {
            System.setSecurityManager((SecurityManager)((Object)new AppletSecurity()));
        } else {
            System.err.println(Main.lookup("main.nosecmgr"));
        }
    }

    private Properties getAVProps() {
        Properties properties = new Properties();
        File file = theUserPropertiesFile;
        if (file.exists()) {
            if (file.canRead()) {
                properties = this.getAVProps(file);
            } else {
                System.err.println(Main.lookup("main.warn.cantreadprops", file.toString()));
                properties = this.setDefaultAVProps();
            }
        } else {
            File file2 = new File(System.getProperty("user.home"));
            File file3 = new File(file2, ".hotjava");
            if ((file3 = new File(file3, "properties")).exists()) {
                properties = this.getAVProps(file3);
            } else {
                System.err.println(Main.lookup("main.warn.cantreadprops", file3.toString()));
                properties = this.setDefaultAVProps();
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                properties.store(fileOutputStream, Main.lookup("main.prop.store"));
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println(Main.lookup("main.err.prop.cantsave", file.toString()));
            }
        }
        return properties;
    }

    private Properties setDefaultAVProps() {
        Properties properties = new Properties();
        int n = 0;
        while (n < avDefaultUserProps.length) {
            properties.setProperty(avDefaultUserProps[n][0], avDefaultUserProps[n][1]);
            ++n;
        }
        return properties;
    }

    private Properties getAVProps(File file) {
        Properties properties = new Properties();
        Properties properties2 = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            properties2.load(new BufferedInputStream(fileInputStream));
            fileInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(Main.lookup("main.err.prop.cantread", file.toString()));
        }
        int n = 0;
        while (n < avDefaultUserProps.length) {
            String string = properties2.getProperty(avDefaultUserProps[n][0]);
            if (string != null) {
                properties.setProperty(avDefaultUserProps[n][0], string);
            } else {
                properties.setProperty(avDefaultUserProps[n][0], avDefaultUserProps[n][1]);
            }
            ++n;
        }
        return properties;
    }

    private static String lookup(String string) {
        return amh.getMessage(string);
    }

    private static String lookup(String string, String string2) {
        return amh.getMessage(string, string2);
    }

    private static String lookup(String string, String string2, String string3) {
        return amh.getMessage(string, string2, string3);
    }

    private static String lookup(String string, String string2, String string3, String string4) {
        return amh.getMessage(string, string2, string3, string4);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        avDefaultUserProps = new String[][]{{"http.proxyHost", ""}, {"http.proxyPort", "80"}, {"package.restrict.access.sun", "true"}};
        File file = new File(System.getProperty("user.home"));
        file.canWrite();
        theUserPropertiesFile = new File(file, ".appletviewer");
        amh = new AppletMessageHandler("appletviewer");
        cmdLineTestFlag = false;
        urlList = new Vector(1);
        theVersion = System.getProperty("java.version");
    }

    class ParseException
    extends RuntimeException {
        Throwable t;

        public ParseException(String string) {
            super(string);
            this.t = null;
        }

        public ParseException(Throwable throwable) {
            super(throwable.getMessage());
            this.t = null;
            this.t = throwable;
        }
    }
}

