/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSObject;
import org.pdfbox.cos.COSStream;
import org.pdfbox.cos.COSString;
import org.pdfbox.encryption.DocumentEncryption;
import org.pdfbox.encryption.PDFEncryption;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.exceptions.CryptographyException;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.pdfwriter.COSWriter;
import org.pdfbox.pdmodel.PDDocumentCatalog;
import org.pdfbox.pdmodel.PDDocumentInformation;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.PDPageNode;
import org.pdfbox.pdmodel.common.PDStream;
import org.pdfbox.pdmodel.encryption.PDEncryptionDictionary;
import org.pdfbox.pdmodel.encryption.PDEncryptionManager;
import org.pdfbox.pdmodel.encryption.PDStandardEncryption;

public class PDDocument {
    private COSDocument document;
    private PDDocumentInformation documentInformation;
    private PDDocumentCatalog documentCatalog;
    private PDEncryptionDictionary encParameters = null;
    private boolean decryptedWithOwnerPassword = false;

    public PDDocument() throws IOException {
        this.document = new COSDocument();
        COSDictionary trailer = new COSDictionary();
        this.document.setTrailer(trailer);
        COSDictionary rootDictionary = new COSDictionary();
        COSObject root = new COSObject(rootDictionary);
        this.document.addObject(root);
        trailer.setItem(COSName.getPDFName("Root"), (COSBase)root);
        rootDictionary.setItem(COSName.getPDFName("Type"), (COSBase)COSName.getPDFName("Catalog"));
        rootDictionary.setItem(COSName.getPDFName("Version"), (COSBase)COSName.getPDFName("1.4"));
        COSDictionary pages = new COSDictionary();
        COSObject pagesObject = new COSObject(pages);
        this.document.addObject(pagesObject);
        rootDictionary.setItem(COSName.getPDFName("Pages"), (COSBase)pagesObject);
        pages.setItem(COSName.getPDFName("Type"), (COSBase)COSName.getPDFName("Pages"));
        COSArray kidsArray = new COSArray();
        pages.setItem(COSName.getPDFName("Kids"), (COSBase)kidsArray);
        pages.setItem(COSName.getPDFName("Count"), (COSBase)new COSInteger(0));
    }

    public void addPage(PDPage page) {
        PDPageNode rootPages = this.getDocumentCatalog().getPages();
        rootPages.getKids().add(page);
        page.setParent(rootPages);
        rootPages.updateCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDPage importPage(PDPage page) throws IOException {
        OutputStream os;
        PDPage importedPage;
        block6: {
            importedPage = new PDPage(new COSDictionary(page.getCOSDictionary()));
            InputStream is = null;
            os = null;
            try {
                PDStream src = page.getContents();
                PDStream dest = new PDStream(new COSStream(src.getStream(), this.document.getScratchFile()));
                importedPage.setContents(dest);
                os = dest.createOutputStream();
                byte[] buf = new byte[10240];
                int amountRead = 0;
                is = src.createInputStream();
                while ((amountRead = is.read(buf, 0, 10240)) > -1) {
                    os.write(buf, 0, amountRead);
                }
                this.addPage(importedPage);
                Object var10_9 = null;
                if (is == null) break block6;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
                throw throwable;
            }
            is.close();
        }
        if (os != null) {
            os.close();
        }
        return importedPage;
    }

    public PDDocument(COSDocument doc) {
        this.document = doc;
    }

    public COSDocument getDocument() {
        return this.document;
    }

    public PDDocumentInformation getDocumentInformation() {
        if (this.documentInformation == null) {
            COSName infoName = COSName.getPDFName("Info");
            COSDictionary trailer = this.document.getTrailer();
            COSDictionary infoDic = (COSDictionary)trailer.getDictionaryObject(infoName);
            if (infoDic == null) {
                infoDic = new COSDictionary();
                trailer.setItem(infoName, (COSBase)infoDic);
            }
            this.documentInformation = new PDDocumentInformation(infoDic);
        }
        return this.documentInformation;
    }

    public void setDocumentInformation(PDDocumentInformation info) {
        this.documentInformation = info;
        this.document.getTrailer().setItem(COSName.getPDFName("Info"), (COSBase)info.getDictionary());
    }

    public PDDocumentCatalog getDocumentCatalog() {
        if (this.documentCatalog == null) {
            COSDictionary trailer = this.document.getTrailer();
            COSDictionary infoDic = (COSDictionary)trailer.getDictionaryObject(COSName.ROOT);
            this.documentCatalog = infoDic == null ? new PDDocumentCatalog(this) : new PDDocumentCatalog(this, infoDic);
        }
        return this.documentCatalog;
    }

    public boolean isEncrypted() {
        return this.document.isEncrypted();
    }

    public PDEncryptionDictionary getEncryptionDictionary() throws IOException {
        if (this.encParameters == null) {
            this.encParameters = PDEncryptionManager.getEncryptionDictionary(this.document.getEncryptionDictionary());
        }
        return this.encParameters;
    }

    public void setEncryptionDictionary(PDEncryptionDictionary encDictionary) throws IOException {
        this.encParameters = encDictionary;
    }

    public boolean isUserPassword(String password) throws IOException, CryptographyException {
        boolean retval = false;
        PDFEncryption encryptor = new PDFEncryption();
        PDEncryptionDictionary encryptionDictionary = this.getEncryptionDictionary();
        if (encryptionDictionary == null) {
            throw new IOException("Error: Document is not encrypted");
        }
        if (!(encryptionDictionary instanceof PDStandardEncryption)) {
            throw new IOException("Error: Encyption dictionary is not 'Standard'" + encryptionDictionary.getClass().getName());
        }
        COSString documentID = (COSString)this.document.getDocumentID().get(0);
        PDStandardEncryption standard = (PDStandardEncryption)encryptionDictionary;
        retval = encryptor.isUserPassword(password.getBytes(), standard.getUserKey(), standard.getOwnerKey(), standard.getPermissions(), documentID.getBytes(), standard.getRevision(), standard.getLength() / 8);
        return retval;
    }

    public boolean isOwnerPassword(String password) throws IOException, CryptographyException {
        boolean retval = false;
        PDFEncryption encryptor = new PDFEncryption();
        PDEncryptionDictionary encryptionDictionary = this.getEncryptionDictionary();
        if (encryptionDictionary == null) {
            throw new IOException("Error: Document is not encrypted");
        }
        if (!(encryptionDictionary instanceof PDStandardEncryption)) {
            throw new IOException("Error: Encyption dictionary is not 'Standard'" + encryptionDictionary.getClass().getName());
        }
        COSString documentID = (COSString)this.document.getDocumentID().get(0);
        PDStandardEncryption standard = (PDStandardEncryption)encryptionDictionary;
        retval = encryptor.isOwnerPassword(password.getBytes(), standard.getUserKey(), standard.getOwnerKey(), standard.getPermissions(), documentID.getBytes(), standard.getRevision(), standard.getLength() / 8);
        return retval;
    }

    public void decrypt(String password) throws CryptographyException, IOException, InvalidPasswordException {
        this.decryptedWithOwnerPassword = this.isOwnerPassword(password);
        DocumentEncryption decryptor = new DocumentEncryption(this);
        decryptor.decryptDocument(password);
        this.document.dereferenceObjectStreams();
    }

    public boolean wasDecryptedWithOwnerPassword() {
        return this.decryptedWithOwnerPassword;
    }

    public void encrypt(String ownerPassword, String userPassword) throws CryptographyException, IOException {
        DocumentEncryption decryptor = new DocumentEncryption(this);
        decryptor.encryptDocument(ownerPassword, userPassword);
    }

    public static PDDocument load(String filename) throws IOException {
        return PDDocument.load(new BufferedInputStream(new FileInputStream(filename)));
    }

    public static PDDocument load(File file) throws IOException {
        return PDDocument.load(new BufferedInputStream(new FileInputStream(file)));
    }

    public static PDDocument load(InputStream input) throws IOException {
        PDFParser parser = new PDFParser(input);
        parser.parse();
        return parser.getPDDocument();
    }

    public void save(String fileName) throws IOException, COSVisitorException {
        this.save(new FileOutputStream(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(OutputStream output) throws IOException, COSVisitorException {
        COSWriter writer = null;
        try {
            writer = new COSWriter(output);
            writer.write(this.document);
            writer.close();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public int getPageCount() throws IOException {
        COSObject catalog = this.document.getCatalog();
        COSObject pages = (COSObject)catalog.getItem(COSName.PAGES);
        return this.getPageCount(pages);
    }

    private int getPageCount(COSObject pages) {
        COSArray pagesArray = (COSArray)pages.getDictionaryObject(COSName.KIDS);
        int pagecount = 0;
        if (pagesArray != null) {
            for (int i = 0; i < pagesArray.size(); ++i) {
                COSObject pageChild = (COSObject)pagesArray.get(i);
                pagecount += this.getPageCount(pageChild);
            }
        } else {
            ++pagecount;
        }
        return pagecount;
    }

    public void close() throws IOException {
        this.document.close();
    }
}

