/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.cmapparser;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.List;
import org.pdfbox.cmaptypes.CMap;
import org.pdfbox.cmaptypes.CodespaceRange;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdfparser.PDFStreamParser;
import org.pdfbox.util.PDFOperator;

public class CMapParser {
    private static final String BEGIN_CODESPACE_RANGE = "begincodespacerange";
    private static final String BEGIN_BASE_FONT_CHAR = "beginbfchar";
    private static final String BEGIN_BASE_FONT_RANGE = "beginbfrange";
    private InputStream input;
    private CMap result;
    private RandomAccessFile file;

    public CMapParser(InputStream in, RandomAccessFile raf) {
        this.input = in;
        this.file = raf;
    }

    public CMap getResult() {
        return this.result;
    }

    public void parse() throws IOException {
        this.result = new CMap();
        PDFStreamParser parser = new PDFStreamParser(this.input, this.file);
        parser.parse();
        List tokens = parser.getTokens();
        for (int i = 0; i < tokens.size(); ++i) {
            int j;
            COSNumber cosCount;
            Object token = tokens.get(i);
            if (!(token instanceof PDFOperator)) continue;
            PDFOperator op = (PDFOperator)token;
            if (op.getOperation().equals(BEGIN_CODESPACE_RANGE)) {
                cosCount = (COSNumber)tokens.get(i - 1);
                for (j = 0; j < cosCount.intValue(); ++j) {
                    COSString startRange = (COSString)tokens.get(++i);
                    COSString endRange = (COSString)tokens.get(++i);
                    CodespaceRange range = new CodespaceRange();
                    range.setStart(startRange.getBytes());
                    range.setEnd(endRange.getBytes());
                    this.result.addCodespaceRange(range);
                }
                continue;
            }
            if (op.getOperation().equals(BEGIN_BASE_FONT_CHAR)) {
                cosCount = (COSNumber)tokens.get(i - 1);
                for (j = 0; j < cosCount.intValue(); ++j) {
                    Object nextToken;
                    COSString inputCode = (COSString)tokens.get(++i);
                    if ((nextToken = tokens.get(++i)) instanceof COSString) {
                        byte[] bytes = ((COSString)nextToken).getBytes();
                        String value = this.createStringFromBytes(bytes);
                        this.result.addMapping(inputCode.getBytes(), value);
                        continue;
                    }
                    if (nextToken instanceof COSName) {
                        this.result.addMapping(inputCode.getBytes(), ((COSName)nextToken).getName());
                        continue;
                    }
                    throw new IOException("Error parsing CMap beginbfchar, expected{COSString or COSName} and not " + nextToken);
                }
                continue;
            }
            if (!op.getOperation().equals(BEGIN_BASE_FONT_RANGE)) continue;
            cosCount = (COSNumber)tokens.get(i - 1);
            for (j = 0; j < cosCount.intValue(); ++j) {
                COSString startCode = (COSString)tokens.get(++i);
                COSString endCode = (COSString)tokens.get(++i);
                Object nextToken = tokens.get(++i);
                COSArray array = null;
                if (nextToken instanceof COSArray) {
                    array = (COSArray)nextToken;
                }
                byte[] startBytes = startCode.getBytes();
                byte[] endBytes = endCode.getBytes();
                byte[] tokenBytes = null;
                tokenBytes = array == null ? ((COSString)nextToken).getBytes() : ((COSString)array.get(0)).getBytes();
                String value = null;
                int arrayIndex = 0;
                boolean done = false;
                while (!done) {
                    if (this.compare(startBytes, endBytes) >= 0) {
                        done = true;
                    }
                    value = this.createStringFromBytes(tokenBytes);
                    this.result.addMapping(startBytes, value);
                    this.increment(startBytes);
                    if (array == null) {
                        this.increment(tokenBytes);
                        continue;
                    }
                    if (arrayIndex >= array.size()) continue;
                    tokenBytes = ((COSString)array.get(arrayIndex++)).getBytes();
                }
            }
        }
    }

    private void increment(byte[] data) {
        this.increment(data, data.length - 1);
    }

    private void increment(byte[] data, int position) {
        if (position > 0 && (data[position] + 256) % 256 == 255) {
            data[position] = 0;
            this.increment(data, position - 1);
        } else {
            data[position] = (byte)(data[position] + 1);
        }
    }

    private String createStringFromBytes(byte[] bytes) throws IOException {
        String retval = null;
        retval = bytes.length == 1 ? new String(bytes) : new String(bytes, "UTF-16BE");
        return retval;
    }

    private int compare(byte[] first, byte[] second) {
        int retval = 1;
        boolean done = false;
        for (int i = 0; i < first.length && !done; ++i) {
            if (first[i] == second[i]) continue;
            if ((first[i] + 256) % 256 < (second[i] + 256) % 256) {
                done = true;
                retval = -1;
                continue;
            }
            done = true;
            retval = 1;
        }
        return retval;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("usage: java org.pdfbox.cmapparser.CMapParser <CMAP File>");
            System.exit(-1);
        }
        CMapParser parser = new CMapParser(new FileInputStream(args[0]), null);
        parser.parse();
        CMap result = parser.getResult();
        System.out.println("Result:" + result);
    }
}

