/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.common;

import java.awt.Dimension;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSFloat;
import org.pdfbox.cos.COSNumber;

public class PDRectangle {
    private COSArray rectArray;

    public PDRectangle() {
        this.rectArray = new COSArray();
        this.rectArray.add(new COSFloat(0.0f));
        this.rectArray.add(new COSFloat(0.0f));
        this.rectArray.add(new COSFloat(0.0f));
        this.rectArray.add(new COSFloat(0.0f));
    }

    public PDRectangle(COSArray array) {
        this.rectArray = array;
    }

    public COSArray getCOSArray() {
        return this.rectArray;
    }

    public float getLowerLeftX() {
        return ((COSNumber)this.rectArray.get(0)).floatValue();
    }

    public void setLowerLeftX(float value) {
        this.rectArray.set(0, new COSFloat(value));
    }

    public float getLowerLeftY() {
        return ((COSNumber)this.rectArray.get(1)).floatValue();
    }

    public void setLowerLeftY(float value) {
        this.rectArray.set(1, new COSFloat(value));
    }

    public float getUpperRightX() {
        return ((COSNumber)this.rectArray.get(2)).floatValue();
    }

    public void setUpperRightX(float value) {
        this.rectArray.set(2, new COSFloat(value));
    }

    public float getUpperRightY() {
        return ((COSNumber)this.rectArray.get(3)).floatValue();
    }

    public void setUpperRightY(float value) {
        this.rectArray.set(3, new COSFloat(value));
    }

    public float getWidth() {
        return this.getUpperRightX() - this.getLowerLeftX();
    }

    public float getHeight() {
        return this.getUpperRightY() - this.getLowerLeftY();
    }

    public Dimension createDimension() {
        return new Dimension((int)this.getWidth(), (int)this.getHeight());
    }

    public String toString() {
        return "[" + this.getLowerLeftX() + "," + this.getLowerLeftY() + "," + this.getUpperRightX() + "," + this.getUpperRightY() + "]";
    }
}

