/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.log4j.Logger;
import org.pdfbox.encryption.DecryptDocument;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.pdfwriter.COSWriter;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.util.Splitter;

public class PDFSplit {
    private static final Logger LOG = Logger.getLogger((Class)(class$org$pdfbox$PDFSplit == null ? (class$org$pdfbox$PDFSplit = PDFSplit.class$("org.pdfbox.PDFSplit")) : class$org$pdfbox$PDFSplit));
    private static final String PASSWORD = "-password";
    private static final String SPLIT = "-split";
    static /* synthetic */ Class class$org$pdfbox$PDFSplit;

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        Throwable throwable2;
        block25: {
            int i3;
            List documents;
            block24: {
                boolean currentArgumentIndex = false;
                String password = "";
                String split = "1";
                Splitter splitter = new Splitter();
                String pdfFile = null;
                int i2 = 0;
                while (i2 < args.length) {
                    if (args[i2].equals(PASSWORD)) {
                        if (++i2 >= args.length) {
                            PDFSplit.usage();
                        }
                        password = args[i2];
                    } else if (args[i2].equals(SPLIT)) {
                        if (++i2 >= args.length) {
                            PDFSplit.usage();
                        }
                        split = args[i2];
                    } else if (pdfFile == null) {
                        pdfFile = args[i2];
                    }
                    ++i2;
                }
                if (pdfFile == null) {
                    PDFSplit.usage();
                }
                FileInputStream input = null;
                Object output = null;
                PDDocument document = null;
                documents = null;
                try {
                    block27: {
                        int i3;
                        block26: {
                            input = new FileInputStream(pdfFile);
                            document = PDFSplit.parseDocument(input);
                            if (document.isEncrypted()) {
                                try {
                                    DecryptDocument decryptor = new DecryptDocument(document);
                                    decryptor.decryptDocument(password);
                                }
                                catch (InvalidPasswordException e) {
                                    if (args.length == 4) {
                                        System.err.println("Error: The supplied password is incorrect.");
                                        System.exit(2);
                                    }
                                    System.err.println("Error: The document is encrypted.");
                                    PDFSplit.usage();
                                }
                            }
                            splitter.setSplitAtPage(Integer.parseInt(split));
                            documents = splitter.split(document);
                            int i4 = 0;
                            while (i4 < documents.size()) {
                                PDDocument doc = (PDDocument)documents.get(i4);
                                String fileName = pdfFile.substring(0, pdfFile.length() - 4) + "-" + i4 + ".pdf";
                                PDFSplit.writeDocument(doc, fileName);
                                ++i4;
                            }
                            Object var15_16 = null;
                            if (input != null) {
                                ((InputStream)input).close();
                            }
                            if (document != null) {
                                document.close();
                            }
                            i3 = 0;
                            if (!true) break block26;
                            if (documents == null) return;
                            if (i3 >= documents.size()) break block27;
                        }
                        do {
                            PDDocument doc = (PDDocument)documents.get(i3);
                            doc.close();
                            ++i3;
                            if (documents == null) return;
                        } while (i3 < documents.size());
                    }
                    return;
                }
                catch (Throwable throwable2) {
                    Object var15_17 = null;
                    if (input != null) {
                        ((InputStream)input).close();
                    }
                    if (document != null) {
                        document.close();
                    }
                    i3 = 0;
                    if (!true) break block24;
                    if (documents == null) throw throwable2;
                    if (i3 >= documents.size()) break block25;
                }
            }
            do {
                PDDocument doc = (PDDocument)documents.get(i3);
                doc.close();
                ++i3;
                if (documents == null) throw throwable2;
            } while (i3 < documents.size());
        }
        throw throwable2;
    }

    private static final void writeDocument(PDDocument doc, String fileName) throws IOException, COSVisitorException {
        COSWriter writer;
        block5: {
            FileOutputStream output = null;
            writer = null;
            try {
                output = new FileOutputStream(fileName);
                writer = new COSWriter(output);
                writer.write(doc);
                Object var5_4 = null;
                if (output == null) break block5;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (output != null) {
                    output.close();
                }
                if (writer != null) {
                    writer.close();
                }
                throw throwable;
            }
            output.close();
        }
        if (writer != null) {
            writer.close();
        }
    }

    private static PDDocument parseDocument(InputStream input) throws IOException {
        PDFParser parser = new PDFParser(input);
        parser.parse();
        return parser.getPDDocument();
    }

    private static void usage() {
        System.err.println("Usage: java org.pdfbox.PDFSplit [OPTIONS] <PDF file>\n  -password  <password>        Password to decrypt document\n  -split     <integer>         split after this many pages\n  <PDF file>                   The PDF document to use\n");
        System.exit(1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

