/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Method;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.BaseLineInfo;
import com.sun.tools.jdi.ConcreteMethodImpl;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.JNITypeParser;
import com.sun.tools.jdi.LineInfo;
import com.sun.tools.jdi.NonConcreteMethodImpl;
import com.sun.tools.jdi.ReferenceTypeImpl;
import com.sun.tools.jdi.SDE;
import com.sun.tools.jdi.StratumLineInfo;
import com.sun.tools.jdi.TypeComponentImpl;
import com.sun.tools.jdi.ValueContainer;
import com.sun.tools.jdi.ValueImpl;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class MethodImpl
extends TypeComponentImpl
implements Method {
    private JNITypeParser signatureParser;

    abstract int argSlotCount() throws AbsentInformationException;

    abstract List allLineLocations(SDE.Stratum var1, String var2) throws AbsentInformationException;

    abstract List locationsOfLine(SDE.Stratum var1, String var2, int var3) throws AbsentInformationException;

    MethodImpl(VirtualMachine virtualMachine, ReferenceTypeImpl referenceTypeImpl, long l, String string, String string2, int n) {
        super(virtualMachine, referenceTypeImpl, l, string, string2, n);
        this.signatureParser = new JNITypeParser(string2);
    }

    static MethodImpl createMethodImpl(VirtualMachine virtualMachine, ReferenceTypeImpl referenceTypeImpl, long l, String string, String string2, int n) {
        if ((n & 0x500) != 0) {
            return new NonConcreteMethodImpl(virtualMachine, referenceTypeImpl, l, string, string2, n);
        }
        return new ConcreteMethodImpl(virtualMachine, referenceTypeImpl, l, string, string2, n);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof MethodImpl) {
            MethodImpl methodImpl = (MethodImpl)object;
            return this.declaringType().equals(methodImpl.declaringType()) && this.ref() == methodImpl.ref() && super.equals(object);
        }
        return false;
    }

    public int hashCode() {
        return (int)this.ref();
    }

    public final List allLineLocations() throws AbsentInformationException {
        return this.allLineLocations(this.vm.getDefaultStratum(), null);
    }

    public List allLineLocations(String string, String string2) throws AbsentInformationException {
        return this.allLineLocations(this.declaringType.stratum(string), string2);
    }

    public final List locationsOfLine(int n) throws AbsentInformationException {
        return this.locationsOfLine(this.vm.getDefaultStratum(), null, n);
    }

    public List locationsOfLine(String string, String string2, int n) throws AbsentInformationException {
        return this.locationsOfLine(this.declaringType.stratum(string), string2, n);
    }

    LineInfo codeIndexToLineInfo(SDE.Stratum stratum, long l) {
        if (stratum.isJava()) {
            return new BaseLineInfo(-1, this.declaringType);
        }
        return new StratumLineInfo(stratum.id(), -1, null, null);
    }

    public String returnTypeName() {
        return this.signatureParser.typeName();
    }

    private String returnSignature() {
        return this.signatureParser.signature();
    }

    public Type returnType() throws ClassNotLoadedException {
        return this.findType(this.returnSignature());
    }

    public Type findType(String string) throws ClassNotLoadedException {
        ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)this.declaringType();
        return referenceTypeImpl.findType(string);
    }

    public List argumentTypeNames() {
        return this.signatureParser.argumentTypeNames();
    }

    public List argumentSignatures() {
        return this.signatureParser.argumentSignatures();
    }

    Type argumentType(int n) throws ClassNotLoadedException {
        ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)this.declaringType();
        String string = (String)this.argumentSignatures().get(n);
        return referenceTypeImpl.findType(string);
    }

    public List argumentTypes() throws ClassNotLoadedException {
        int n = this.argumentSignatures().size();
        ArrayList<Type> arrayList = new ArrayList<Type>(n);
        int n2 = 0;
        while (n2 < n) {
            Type type = this.argumentType(n2);
            arrayList.add(type);
            ++n2;
        }
        return arrayList;
    }

    public int compareTo(Object object) {
        Method method = (Method)object;
        ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)this.declaringType();
        int n = referenceTypeImpl.compareTo(method.declaringType());
        if (n == 0) {
            n = referenceTypeImpl.indexOf(this) - referenceTypeImpl.indexOf(method);
        }
        return n;
    }

    public boolean isAbstract() {
        return this.isModifierSet(1024);
    }

    public boolean isSynchronized() {
        return this.isModifierSet(32);
    }

    public boolean isNative() {
        return this.isModifierSet(256);
    }

    public boolean isConstructor() {
        return this.name().equals("<init>");
    }

    public boolean isStaticInitializer() {
        return this.name().equals("<clinit>");
    }

    public boolean isObsolete() {
        try {
            return JDWP.Method.IsObsolete.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this.declaringType, (long)this.ref).isObsolete;
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    void prepareArgumentsForInvoke(List list) throws ClassNotLoadedException, InvalidTypeException {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Value value = (Value)list.get(n2);
            value = ValueImpl.prepareForAssignment(value, new ArgumentContainer(n2));
            list.set(n2, value);
            ++n2;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.declaringType().name());
        stringBuffer.append(".");
        stringBuffer.append(this.name());
        stringBuffer.append("(");
        boolean bl = true;
        Iterator iterator = this.argumentTypeNames().iterator();
        while (iterator.hasNext()) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append((String)iterator.next());
            bl = false;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    class ArgumentContainer
    implements ValueContainer {
        int index;

        ArgumentContainer(int n) {
            this.index = n;
        }

        public Type type() throws ClassNotLoadedException {
            return MethodImpl.this.argumentType(this.index);
        }

        public String typeName() {
            return (String)MethodImpl.this.argumentTypeNames().get(this.index);
        }

        public String signature() {
            return (String)MethodImpl.this.argumentSignatures().get(this.index);
        }

        public Type findType(String string) throws ClassNotLoadedException {
            return MethodImpl.this.findType(string);
        }
    }
}

